@extends('layouts.front')
@section('content')
    <main class="container-fluid view-container">
        <div class="container">
            <div class="row pt-5 pt-5">
                <div class="col-lg-10 col-md-10 col-sm-12 view-card m-auto">
                    <div class="row w-50 ms-auto align-items-center">
                        <div class="col-md-10 mb-5 text-end">
                            @php
                                $percentage = ($currentInputsNum / $totalInputs) * 100;
                            @endphp
                            <div class="progress" style="height:5px">
                                <div class="progress-bar bg-danger" role="progressbar" style="width: {{ $percentage }}%"
                                    aria-valuenow="{{ $totalInputs }}" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
                        <div class="col-md-2 mb-5 text-end">
                            <span>{{ $currentInputsNum }}/{{ $totalInputs }}</span>
                        </div>
                    </div>
                    <h3>{{ $projectForm->form->name }}</h3>
                    <p>
                        {{ $projectForm->form->desc }}
                    </p>
                    <div class="content">
                        <div class="row">
                            <h5 class="text-end">{{ $projectForm->expiration_date }}</h5>
                        </div>
                        <div class="form-content">
                            <div class="d-flex justify-content-between">
                                <div class="attached-title d-flex justify-content-center">
                                    <h5>
                                        Attached Files
                                    </h5>
                                </div>
                            </div>
                            <div class="attached-data">
                                <div class="row align-items-center">
                                    @foreach ($projectForm->form->formFiles as $file)
                                        @switch($file->type)
                                            @case('image/png')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox="gallery">
                                                        <img width="50px" height="50px" src="{{ url($file->file_path) }}"
                                                            alt="">
                                                    </a>
                                                </div>
                                            @break

                                            @case('image/jpg')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox="gallery">
                                                        <img width="50px" height="50px" src="{{ url($file->file_path) }}"
                                                            alt="">
                                                    </a>
                                                </div>
                                            @break

                                            @case('image/jpeg')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox="gallery">
                                                        <img width="50px" height="50px" src="{{ url($file->file_path) }}"
                                                            alt="">
                                                    </a>
                                                </div>
                                            @break

                                            @case('application/pdf')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox data-type="iframe">
                                                        <img src="{{ url('front_end/assets/imgs/file-icon.png') }}" alt="">
                                                    </a>
                                                </div>
                                            @break

                                            @default
                                        @endswitch
                                    @endforeach


                                </div>
                            </div>
                        </div>
                        <div class="form-content">
                            <div class="form-data">
                                <div class="row">
                                    @foreach ($formInputs as $key => $input)
                                        @switch($input->input_type)
                                            @case('text')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                    <label for="text-input"
                                                        class="form-label">{{ $input->formInput->label }}</label>
                                                    <input name="inputs[{{ $input->id }}][answer]" type="text"
                                                        id="text-input{{ $key }}" value="{{ $input->answer }}"
                                                        class="form-control" disabled>
                                                </div>
                                            @break

                                            @case('number')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                    <label for="number-input"
                                                        class="form-label">{{ $input->formInput->label }}</label>
                                                    <input step="1" type="number" value="{{ $input->answer }}" disabled
                                                        id="number-input{{ $key }}" class="form-control"
                                                        name="inputs[{{ $input->id }}][answer]">
                                                </div>
                                            @break

                                            @case('textarea')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                    <label for="textarea-input"
                                                        class="form-label">{{ $input->formInput->label }}</label>
                                                    <textarea disabled class="form-control resize-none" name="inputs[{{ $input->id }}][answer]"
                                                        id="textarea-input{{ $key }}" rows="3">{{ $input->answer }}</textarea>
                                                    <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                        value="{{ $input->input_type }}">
                                                </div>
                                            @break

                                            @case('file')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3 custom-file">
                                                    <label for="number-input"
                                                        class="form-label">{{ $input->formInput->label }}</label>
                                                    @if ($input->answer !=null)
                                                        @if ($input->file_type == 'application/pdf')
                                                            <a id="old-pdf-file" href="{{ url($input->answer) }}" data-fancybox
                                                                data-type="iframe">
                                                                <img src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                                    alt="">
                                                            </a>
                                                        @else
                                                            <a href="{{ url($input->answer) }}" data-fancybox="gallery">
                                                                <img class="old-img" width="60px" src="{{ url($input->answer) }}"
                                                                    alt="">
                                                            </a>
                                                        @endif
                                                    @endif
                                                </div>
                                            @break
                                            @case('checkbox')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                    <label for="textarea-input"
                                                           class="form-label">{{ $input->formInput->label }}</label>
                                                    @if($input->formInput->inputsElemnts != null)
                                                        @foreach($input->formInput->inputsElemnts as $el)
                                                            <div class="checkbox-group">
                                                                <input type="checkbox" id="{{$el->name }}"
                                                                       name="inputs[{{ $input->id }}][answer][]"
                                                                       class="filled-in chk-col-danger checkbox-input"
                                                                       value="{{$el->id}}"
                                                                @if($input->answer!=null)
                                                                    {{in_array($el->id,json_decode($input->answer,true)) ?'checked':''}}
                                                                    @endif
                                                                />
                                                                <label for="{{$el->name}}"
                                                                       class="form-label checkbox-label">{{ $el->name }}</label>
                                                            </div>
                                                        @endforeach
                                                    @endif

                                                </div>
                                                @break
                                            @case('radio')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                    <label for="textarea-input"
                                                           class="form-label">{{ $input->formInput->label }}</label>
                                                    @if($input->formInput->inputsElemnts != null)
                                                        @foreach($input->formInput->inputsElemnts as $el)
                                                            <div class="checkbox-group">
                                                                <input type="radio" id="{{$el->name }}"
                                                                       name="inputs[{{ $input->id }}][answer]"
                                                                       class="filled-in chk-col-danger checkbox-input"
                                                                       value="{{$el->id}}"
                                                                @if($input->answer!=null)
                                                                    {{$el->id == $input->answer ?'checked':''}}
                                                                    @endif
                                                                />
                                                                <label for="{{$el->name}}"
                                                                       class="form-label checkbox-label">{{ $el->name }}</label>

                                                            </div>

                                                        @endforeach
                                                    @endif

                                                </div>
                                                @break

                                            @default
                                        @endswitch
                                    @endforeach

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            @if ($prevPage != 0)
                                <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper">
                                    <a href="{{ route('viewForm', ['project_form_id' => $projectForm->id, 'page' => $prevPage]) }}"
                                        class="btn save-btn d-block py-2 fs-5">Prev</a>
                                </div>
                            @endif
                            @if ($nextPage != $totalPages + 1)
                                <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper ms-auto">
                                    <a href="{{ route('viewForm', ['project_form_id' => $projectForm->id, 'page' => $nextPage]) }}"
                                        class="btn save-btn d-block py-2 fs-5">Next</a>
                                </div>
                                @else
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper ms-auto">
                                        <a href="{{ route('home') }}"
                                           class="btn save-btn d-block py-2 fs-5">back</a>
                                    </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-fancybox="gallery"]').fancybox({
                loop: true,
                keyboard: true,
                arrows: true,
                infobar: true,
                buttons: [
                    "thumbs",
                    "close",
                    "download"
                ]
            });
        })
    </script>
@endsection
