@extends('layouts.front')
@section('content')
    <main class="container-fluid view-container">
        <div class="container" id="remove-on-submition">
            <div class="row pt-5 pt-5">
                <div class="col-lg-10 col-md-10 col-sm-12 view-card m-auto">
                    <div class="row w-50 ms-auto align-items-center">
                        <div class="col-md-10 mb-5 text-end">
                            @php
                                $percentage = ($currentInputsNum / $totalInputs) * 100;
                            @endphp
                            <div class="progress" style="height:5px">
                                <div class="progress-bar bg-danger" role="progressbar" style="width: {{ $percentage }}%"
                                     aria-valuenow="{{ $totalInputs }}" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
                        <div class="col-md-2 mb-5 text-end">
                            <span>{{ $currentInputsNum }}/{{ $totalInputs }}</span>
                        </div>
                    </div>
                    <h3>{{ $projectForm->form->name }}</h3>
                    <p>
                        {{ $projectForm->form->desc }}
                    </p>
                    <div class="content">
                        <div class="row">
                            <h5 class="text-end">{{ $projectForm->created_at }}</h5>
                        </div>
                        <div class="form-content">
                            <div class="d-flex justify-content-between">
                                <div class="attached-title d-flex justify-content-center">
                                    <h5>
                                        Attached Files
                                    </h5>
                                </div>
                            </div>
                            <div class="attached-data">
                                <div class="row align-items-center">
                                    @foreach ($projectForm->Form->formFiles as $file)
                                        @switch($file->type)
                                            @case('image/png')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox="gallery">
                                                        <img width="50px" height="50px"
                                                             src="{{ url($file->file_path) }}"
                                                             alt="">
                                                    </a>
                                                </div>
                                                @break

                                            @case('image/jpg')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox="gallery">
                                                        <img width="50px" height="50px"
                                                             src="{{ url($file->file_path) }}"
                                                             alt="">
                                                    </a>
                                                </div>
                                                @break

                                            @case('image/jpeg')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox="gallery">
                                                        <img width="50px" height="50px"
                                                             src="{{ url($file->file_path) }}"
                                                             alt="">
                                                    </a>
                                                </div>
                                                @break

                                            @case('application/pdf')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox
                                                       data-type="iframe">
                                                        <img src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                             alt="">
                                                    </a>
                                                </div>
                                                @break

                                            @default
                                        @endswitch
                                    @endforeach


                                </div>
                            </div>
                        </div>

                        <input type="hidden" name="project_form_id" value="{{ $id }}">
                        <input type="hidden" name="nextPage" value="{{ $nextPage }}">
                        <input type="hidden" name="prevPage" value="{{ $prevPage }}">
                        <input type="hidden" name="show_submit" value="{{ $show_submit }}">
                        <input type="hidden" name="totalPages" value="{{ $totalPages }}">
                        <div class="form-content">
                            <div class="form-data">
                                <div class="row">
                                    @foreach ($formInputs as $key => $input)
                                        @switch($input->input_type)
                                            @case('text')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                    <label for="text-input"
                                                           class="form-label">{{ $input->label }}</label>
                                                    <input type="text"
                                                           placeholder="{{ $input->placeholder }}"
                                                           id="text-input{{ $input->id  }}"
                                                           value="{{$inputs->where('fixed_input_id',$input->id)->first()->answer ?? '' }}"
                                                           class="form-control">

                                                </div>
                                                @break

                                            @case('number')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                    <label for="number-input"
                                                           class="form-label">{{ $input->label }}</label>
                                                    <input step="1" type="number"
                                                           value="{{$inputs->where('fixed_input_id',$input->id)->first()->answer ?? ''}}"
                                                           id="number-input{{ $input->id }}"
                                                           placeholder="{{ $input->placeholder }}"
                                                           class="form-control numberInput"
                                                    >

                                                </div>
                                                @break

                                            @case('textarea')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                    <label for="textarea-input"
                                                           class="form-label">{{ $input->label }}</label>
                                                    <textarea class="form-control resize-none"
                                                              name="inputs[{{ $input->id }}][answer]"
                                                              id="textarea-input{{ $key }}" rows="3"
                                                              placeholder="{{ $input->placeholder }}">{{$inputs->where('fixed_input_id',$input->id)->first()->answer ?? ''}}</textarea>

                                                </div>
                                                @break

                                            @case('file')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3 custom-file">
                                                    <label for="number-input"
                                                           class="form-label">{{ $input->label }}</label>
                                                    <input type="file" id="file-input{{ $input->id }}"
                                                           name="inputs[{{ $input->id }}][answer]"
                                                           class="form-control custom-file-input">
                                                    <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                           value="{{ $input->input_type }}">
                                                    <img width="60px" class="img" id="file-reader-image" src=""
                                                         alt="">
                                                    <a href="#" id="display-pdf-file"
                                                       style="display: none;text-decoration: none" data-fancybox
                                                       data-type="iframe">
                                                        <img src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                             alt="">
                                                    </a>
                                                    @if ($inputs->where('fixed_input_id',$input->id)->first() != null)
                                                        @if ($inputs->where('fixed_input_id',$input->id)->first()->file_type == 'application/pdf')
                                                            <a id="old-pdf-file"
                                                               href="{{ url($inputs->where('fixed_input_id',$input->id)->first()->answer) }}"
                                                               data-fancybox data-type="iframe">
                                                                <img
                                                                    src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                                    alt="">
                                                            </a>
                                                        @else
                                                            @if($inputs->where('fixed_input_id',$input->id)->first()->answer != null)
                                                                <a href="{{ url($inputs->where('fixed_input_id',$input->id)->first()->answer) }}"
                                                                   data-fancybox="gallery">
                                                                    <img class="old-img" width="60px"
                                                                         src="{{ url($inputs->where('fixed_input_id',$input->id)->first()->answer)}}"
                                                                         alt="">
                                                                </a>
                                                            @endif
                                                        @endif
                                                    @endif
                                                </div>
                                                @break
                                            @case('checkbox')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                    <label for="textarea-input"
                                                           class="form-label">{{ $input->label }}</label>
                                                    @if($input->inputsElemnts != null)
                                                        @foreach($input->inputsElemnts as $el)
                                                            <div class="checkbox-group">
                                                                <input type="checkbox" id="{{$el->name }}"
                                                                       name="inputs[{{ $input->id }}][answer][]"
                                                                       class="filled-in chk-col-danger checkbox-input"
                                                                       value="{{$el->id}}"
                                                                @if($inputs->where('fixed_input_id',$input->id)->first() !=null && $inputs->where('fixed_input_id',$input->id)->first()->answer !=null)
                                                                    {{in_array($el->id,json_decode($inputs->where('fixed_input_id',$input->id)->first()->answer,true)) ?'checked':''}}
                                                                    @endif

                                                                />
                                                                <label for="{{$el->name}}"
                                                                       class="form-label checkbox-label">{{ $el->name }}</label>
                                                            </div>

                                                        @endforeach
                                                    @endif

                                                </div>
                                                @break
                                            @case('radio')
                                                <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                    <label for="textarea-input"
                                                           class="form-label">{{ $input->label }}</label>
                                                    @if($input->inputsElemnts != null)
                                                        @foreach($input->inputsElemnts as $el)
                                                            <div class="checkbox-group">
                                                                <input type="radio" id="{{$el->name }}"
                                                                       name="inputs[{{ $input->id }}][answer]"
                                                                       class="filled-in chk-col-danger checkbox-input"
                                                                       value="{{$el->id}}"
                                                                @if($inputs->where('fixed_input_id',$input->id)->first() !=null)
                                                                    {{$el->id == $inputs->where('fixed_input_id',$input->id)->first()->answer ?'checked':''}}

                                                                    @endif
                                                                />
                                                                <label for="{{$el->name}}"
                                                                       class="form-label checkbox-label">{{ $el->name }}</label>

                                                            </div>

                                                        @endforeach
                                                    @endif

                                                </div>
                                                @break

                                            @default
                                        @endswitch
                                    @endforeach

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            @if ($prevPage != 0)
                                <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper">
                                    <a href="{{ route('front.fixed.viewForm', ['id' => $projectForm->id, 'page' => $prevPage]) }}"
                                       class="btn save-btn d-block py-2 fs-5">Prev</a>
                                </div>
                            @endif
                            @if ($nextPage != $totalPages + 1)
                                <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper ms-auto">
                                    <a href="{{ route('front.fixed.viewForm', ['id' => $projectForm->id, 'page' => $nextPage]) }}"
                                       class="btn save-btn d-block py-2 fs-5">Next</a>
                                </div>
                                @else
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper ms-auto">
                                        <a href="{{ route('front.fixed.index') }}"
                                           class="btn save-btn d-block py-2 fs-5">back</a>
                                    </div>
                            @endif
                        </div>

                    </div>

                </div>


            </div>
        </div>
    </main>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            $('[data-fancybox="gallery"]').fancybox({
                loop: true,
                keyboard: true,
                arrows: true,
                infobar: true,
                buttons: [
                    "thumbs",
                    "close",
                    "download"
                ]
            });
        })
    </script>
    <script>
        // الحصول على جميع العناصر التي تحتوي على الفئة "numberInput"
        var numberInputs = document.getElementsByClassName('numberInput');

        // إضافة مستمع للأحداث لكل عنصر من العناصر
        Array.from(numberInputs).forEach(function(input) {
            input.addEventListener('input', function() {
                if (this.value < 0) {
                    this.value = 0;
                }
            });

            input.addEventListener('keypress', function(event) {
                if (event.key === '-' || event.key === 'e') {
                    event.preventDefault();
                    this.value = 0;
                }
            });
        });
    </script>
@endsection

