@extends('layouts.front')
@section('title'){{ $form->name }} @stop
@section('content')

    <style>
        .table-page {
            padding: 1.5rem 4rem;
            min-height: 70vh;
            border: 1px solid #e0d7f0;
            border-radius: 1rem;
            margin: 2rem;
        }

        .box-body .table-responsive table {
            margin-block: 1.5rem;
            th {
                white-space: nowrap;
            }
        }
        .dataTables_info {
            margin-bottom: 1rem;
        }
    </style>
    <section class="content table-page">
        <div class="box">
            <div class="box-header">
                <h3 class="text-center">{{ $form->name }}</h3>
            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table id="example" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                        <thead>
                        {!! $thead !!}
                        </thead>
                        <tbody>
                        {!! $tbody !!}
                        </tbody>
                        <tfoot>
                        {!! $thead !!}
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </section>
@endsection


@section('script')
    <script src="{{ url('panel_them/assets/theme_components/datatable/datatables.min.js') }}"></script>
    <script src="{{ url('panel_them/main-semidark/js/buttons.html5.styles.min.js') }}"></script>
    <script src="{{ url('panel_them/main-semidark/js/buttons.html5.styles.templates.min.js') }}"></script>
    <script type="text/javascript">
        $('#example').DataTable({
            paging: false,
            dom: 'Bfrtip',
            searching: false,
            template: "orange_medium", // Apply the "green_medium" template
            buttons: [{
                extend: "excel", // Extend the excel button
                excelStyles: [ // Add an excelStyles definition
                    {
                        template: "orange_medium", // Apply the "green_medium" template
                    },
                    {
                        cells: "sh", // Use Smart References (s) to target the header row (h)
                        style: { // The style definition
                            font: { // Style the font
                                size: 14, // Size 14
                                b: false, // Turn off the default bolding of the header row
                            },
                            fill: { // Style the cell fill
                                pattern: { // Add a pattern (default is solid)
                                    color: "cc0000" // Define the fill color
                                }
                            }
                        }
                    }
                ]
            }, 'print']
        });
    </script>
@endsection
