<?php

use App\Http\Controllers\Admin\BranchController;
use App\Http\Controllers\Admin\FormController;
use App\Http\Controllers\Admin\FormFileController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\ProjectController;
use App\Http\Controllers\Admin\ProjectFormController as AdminProjectFormController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Auth\ProjectAuthController;
use App\Http\Controllers\Front\FrontPageController;
use App\Http\Controllers\Front\ProjectController as FrontProjectController;
use App\Http\Controllers\Front\ProjectFormController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('test',function () {
        return   \Spatie\Activitylog\Models\Activity::find(98);
});
Route::post('/language', [App\Http\Controllers\HomeController::class, 'changeLanguage'])->name('language.change');
Route::get('/project-login', [ProjectAuthController::class, 'showLoginForm'])->name('project.login.form');
Route::post('front/project/getProjectsByBranch', [FrontProjectController::class, 'getProjectsByBranch'])->name('frontProject.getProjectsByBranch');
Route::post('/project-login', [ProjectAuthController::class, 'login'])->name('project.login');

Route::get('/branch-login', [\App\Http\Controllers\Auth\BranchAuthController::class, 'showLoginForm'])->name('branch.login.form');
Route::post('/branch-login', [\App\Http\Controllers\Auth\BranchAuthController::class, 'login'])->name('branch.submit');

Auth::routes();

Route::prefix('admin')->middleware('auth')->group(function () {
    Route::get('/', [App\Http\Controllers\Admin\HomeController::class, 'dashboard'])->name('dashboard');

    Route::controller(\App\Http\Controllers\Admin\LogActivityControllers::class)->group(function () {
        Route::get('log', 'index')->name('log.index');
        Route::get('search', 'search')->name('log.search');
        Route::get('show/{id}/{inlog}', 'show')->name('log.show');

    });
    //Users
    Route::controller(UserController::class)->group(function () {
        Route::get('user', 'index')->name('user.index');
        Route::post('user', 'store')->name('user.store');
        Route::get('user/create', 'create')->name('user.create');
        Route::get('user/{user}', 'show')->name('user.show');
        Route::put('user/{user}', 'update')->name('user.update');
        Route::delete('user/{user}', 'destroy')->name('user.destroy');
        Route::get('user/{user}/edit', 'edit')->name('user.edit');
    });
    //Pages
    Route::controller(PageController::class)->group(function () {
        Route::get('page', 'index')->name('page.index');
        Route::post('page', 'store')->name('page.store');
        Route::get('page/create', 'create')->name('page.create');
        Route::get('page/{page}', 'show')->name('page.show');
        Route::put('page/{page}', 'update')->name('page.update');
        Route::delete('page/{page}', 'destroy')->name('page.destroy');
        Route::get('page/{page}/edit', 'edit')->name('page.edit');
        Route::post('page/updateEnabel', 'updateEnabel')->name('page.updateEnabel');
    });

    //Branches
    Route::controller(BranchController::class)->group(function () {
        Route::get('branch', 'index')->name('branch.index');
        Route::post('branch', 'store')->name('branch.store');
        Route::get('branch/create', 'create')->name('branch.create');
        Route::get('branch/{branch}', 'show')->name('branch.show');
        Route::put('branch/{branch}', 'update')->name('branch.update');
        Route::delete('branch/{branch}', 'destroy')->name('branch.destroy');
        Route::get('branch/{branch}/edit', 'edit')->name('branch.edit');
        Route::get('branch/password/{id}', 'viewPassword')->name('branch.viewpassword');
        Route::post('branch/password/{id}', 'password')->name('branch.password');
        Route::post('branch/updateEnabel', 'updateEnabel')->name('branch.updateEnabel');
        Route::post('uploadBranchExcelFile', 'uploadBranchExcelFile')->name('branch.uploadBranchExcelFile');
    });

    //Projects
    Route::controller(ProjectController::class)->group(function () {
        Route::get('project', 'index')->name('project.index');
        Route::post('project', 'store')->name('project.store');
        Route::get('project/create', 'create')->name('project.create');
        Route::get('project/{project}', 'show')->name('project.show');
        Route::put('project/{project}', 'update')->name('project.update');
        Route::delete('project/{project}', 'destroy')->name('project.destroy');
        Route::get('project/{project}/edit', 'edit')->name('project.edit');
        Route::get('project/password/{id}', 'viewPassword')->name('project.viewpassword');
        Route::post('project/password/{id}', 'password')->name('project.password');
        Route::post('project/getProjectsByBranch', 'getProjectsByBranch')->name('project.getProjectsByBranch');
        Route::post('uploadProjectExcelFile', 'uploadProjectExcelFile')->name('project.uploadProjectExcelFile');
        Route::post('getProjectsByBranchId', 'getProjectsByBranchId')->name('project.getProjectsByBranchId');
    });

    //Forms
    Route::controller(FormController::class)->group(function () {
        Route::get('form', 'index')->name('form.index');
        Route::get('addField', 'addField')->name('form.addField');
        Route::post('uploadFieldsFile', 'uploadFieldsFile')->name('form.uploadFieldsFile');
        Route::get('getPeriodicTypeSelect', 'getPeriodicTypeSelect')->name('form.getPeriodicTypeSelect');
        Route::post('form', 'store')->name('form.store');
        Route::get('form/create', 'create')->name('form.create');
        Route::get('form/{form}', 'show')->name('form.show');
        Route::put('form/{form}', 'update')->name('form.update');
        Route::delete('form/{form}', 'destroy')->name('form.destroy');
        Route::get('form/{form}/edit', 'edit')->name('form.edit');
        Route::get('form/store-continu/{form_id}', 'continueStoreForm')->name('form.continueStoreForm');

    });

    Route::controller(\App\Http\Controllers\Admin\FormFixedController::class)->group(function () {
        Route::get('fixed', 'index')->name('fixed.index');
        Route::get('fixed/create', 'create')->name('fixed.create');
        Route::post('fixed/create', 'store')->name('fixed.store');
        Route::get('fixed/addField', 'addField')->name('fixed.addField');
        Route::post('fixed/uploadFieldsFile', 'uploadFieldsFile')->name('fixed.uploadFieldsFile');
        Route::delete('fixed/{form}', 'destroy')->name('fixed.destroy');
        Route::get('fixed/show/{form}', 'show')->name('fixed.show');
        Route::get('fixed/sended', 'sended')->name('fixed.sended');
        Route::get('fixed/sended/show/{id}', 'showSended')->name('fixed.sended.show');
        Route::get('fixed/pdfDownload/{id}', 'pdfDownload')->name('fixed.pdfDownload');
        Route::get('fixed/del/{id}', 'del')->name('fixed.admin.del');


        /*
        Route::post('uploadFieldsFile', 'uploadFieldsFile')->name('form.uploadFieldsFile');
        Route::get('getPeriodicTypeSelect', 'getPeriodicTypeSelect')->name('form.getPeriodicTypeSelect');
        Route::post('form', 'store')->name('form.store');
       // Route::get('form/create', 'create')->name('form.create');
        Route::get('form/{form}', 'show')->name('form.show');
        Route::put('form/{form}', 'update')->name('form.update');
        Route::delete('form/{form}', 'destroy')->name('form.destroy');
        Route::get('form/{form}/edit', 'edit')->name('form.edit');
        Route::get('form/store-continu/{form_id}', 'continueStoreForm')->name('form.continueStoreForm');*/
    });
    Route::controller(\App\Http\Controllers\Admin\FormFixedFileController::class)->group(function () {
        Route::get('fixed-file/index', 'index')->name('fixed.file.index');
        Route::post('fixed-file/created', 'store')->name('fixed.file.create');
        Route::post('fixed-file/deleted', 'deleted')->name('fixed.file.deleted');
    });
    Route::controller(\App\Http\Controllers\Admin\NotificationBarController::class)->group(function () {
        Route::get('notificationbar/index', 'index')->name('notificationbar.index');
        Route::get('notificationbar/add', 'create')->name('notificationbar.create');
        Route::post('notificationbar/add', 'store')->name('notificationbar.store');
        Route::get('notificationbar/updated/{id?}', 'updated')->name('notificationbar.updated');
        Route::post('notificationbar/updated/{id?}', 'updatedSave')->name('notificationbar.updatedSave');
        Route::delete('notificationbar/del/{id?}', 'del')->name('notificationbar.del');

    });

    //ProjectForm
    Route::controller(AdminProjectFormController::class)->group(function () {
        Route::get('project-form', 'index')->name('projectForm.index');
        Route::post('project-form', 'store')->name('projectForm.store');
        Route::get('project-form/create', 'create')->name('projectForm.create');
        Route::get('project-form/{form}', 'show')->name('projectForm.show');
        Route::put('project-form/{form}', 'update')->name('projectForm.update');
        Route::delete('project-form/{form}', 'destroy')->name('projectForm.destroy');
        Route::get('project-form/{form}/edit', 'edit')->name('projectForm.edit');
        Route::get('project-form-update-expiration', 'updateExpiration')->name('projectForm.updateExpiration');
        Route::get('project-form-publish-forms', 'publishForms')->name('projectForm.publishForms');
        Route::get('form/pdfDownload/{id}', 'pdfDownload')->name('form.pdfDownload');
        Route::get('form/del/{id}', 'del')->name('form.admin.del');
    });

    //Forms
    Route::controller(FormFileController::class)->group(function () {
        Route::get('formFile', 'index')->name('formFile.index');
        Route::post('formFile', 'store')->name('formFile.store');
        Route::get('formFile/create', 'create')->name('formFile.create');
        Route::get('formFile/{formFile}', 'show')->name('formFile.show');
        Route::put('formFile/{formFile}', 'update')->name('formFile.update');
        Route::delete('formFile/{formFile}', 'destroy')->name('formFile.destroy');
        Route::post('formFile/delete', 'delete')->name('formFile.delete');
        Route::get('formFile/{formFile}/edit', 'edit')->name('formFile.edit');
    });

    // Settings
    Route::controller(SettingController::class)->group(function () {
        Route::get('setting', 'index')->name('setting.index');
        Route::post('setting', 'store')->name('setting.store');
        Route::put('setting/{setting}', 'update')->name('setting.update');
    });
    Route::get('/report/general', [ReportController::class, 'general'])->name('report.general');
    Route::get('/report/getGeneral', [ReportController::class, 'getGeneral'])->name('report.getGeneral');
    Route::get('/report/calculated', [ReportController::class, 'calculated'])->name('report.calculated');
    Route::get('/report/getCalculated', [ReportController::class, 'getCalculated'])->name('report.getCalculated');
    Route::get('/report/files', [ReportController::class, 'fromFiles'])->name('report.fromFiles');
    Route::get('/report/getFiles', [ReportController::class, 'getFiles'])->name('report.getFiles');
    Route::get('fixed/report/general', [\App\Http\Controllers\Admin\FixedReportController::class, 'general'])->name('fixed.report.view');
    Route::get('fixed/report/getGeneral', [\App\Http\Controllers\Admin\FixedReportController::class, 'getGeneral'])->name('fixed.report.get');
});
Route::middleware('auth.project')->group(function () {
    Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
    Route::get('/chose', [App\Http\Controllers\HomeController::class, 'ChoseForm'])->name('choseFrom');
    Route::get('/getProjectForms', [ProjectFormController::class, 'getProjectForms'])->name('getProjectForms');
    Route::get('/fill-form/{project_form_id}', [ProjectFormController::class, 'fillForm'])->name('fillForm');
    Route::get('/view-form/{project_form_id}', [ProjectFormController::class, 'viewForm'])->name('viewForm');
    Route::post('/submit-fill-form', [ProjectFormController::class, 'submitFillForm'])->name('submitFillForm');
    //Fixed Forms
    Route::get('/fixed', [\App\Http\Controllers\Front\FormFixedController::class, 'index'])->name('front.fixed.index');
    Route::get('/fixedGet', [\App\Http\Controllers\Front\FormFixedController::class, 'fixedGet'])->name('front.fixed.fixedGet');
    Route::get('/fixedHistory', [\App\Http\Controllers\Front\FormFixedController::class, 'fixedHistory'])->name('front.fixed.fixedHistory');
    Route::get('/fixed/fill-form/{id}', [\App\Http\Controllers\Front\FormFixedController::class, 'fillForm'])->name('front.fixed.fillForm');
    Route::post('/fixed/form-submit/{id}', [\App\Http\Controllers\Front\FormFixedController::class, 'submitForm'])->name('front.fixed.submit');
    Route::get('/fixed/view-form/{id}', [\App\Http\Controllers\Front\FormFixedController::class, 'viewForm'])->name('front.fixed.viewForm');
});
Route::middleware('auth.BranchAuth')->group(function () {
    Route::get('front/branch', [\App\Http\Controllers\Front\BranchFrontController::class, 'index'])->name('branch.front.index');
    Route::get('front/branch/fixed', [\App\Http\Controllers\Front\BranchFrontController::class, 'fixed'])->name('branch.front.fixed');
    Route::get('front/branch/form', [\App\Http\Controllers\Front\BranchFrontController::class, 'form'])->name('branch.front.form');
    Route::get('front/branch/form/get/{id}', [\App\Http\Controllers\Front\BranchFrontController::class, 'fromView'])->name('branch.front.formView');
    Route::post('front/branch/form/get/{id}', [\App\Http\Controllers\Front\BranchFrontController::class, 'submitForm'])->name('branch.front.submit');
    Route::get('front/branch/fixed/get/{id}', [\App\Http\Controllers\Front\BranchFrontController::class, 'fixedView'])->name('branch.front.fixedView');
    Route::post('front/branch/fixed/get/{id}', [\App\Http\Controllers\Front\BranchFrontController::class, 'fixedSubmit'])->name('branch.front.fixedSubmit');
    Route::get('front/branch/form/change/{id}/{status}', [\App\Http\Controllers\Front\BranchFrontController::class, 'ChangeStatusFrom'])->name('branch.front.ChangeStatusFrom');
    Route::get('front/branch/fixed/change/{id}/{status}', [\App\Http\Controllers\Front\BranchFrontController::class, 'ChangeStatusFixed'])->name('branch.front.ChangeStatusFixed');
    Route::get('front/branch/fixed/change/{id}/{status}', [\App\Http\Controllers\Front\BranchFrontController::class, 'ChangeStatusFixed'])->name('branch.front.ChangeStatusFixed');
    Route::get('front/branch/from/del/{id}', [\App\Http\Controllers\Front\BranchFrontController::class, 'DelFrom'])->name('branch.from.del');
    Route::get('front/branch/fixed/del/{id}', [\App\Http\Controllers\Front\BranchFrontController::class, 'del'])->name('branch.fixed.del');
    // reports
    Route::prefix('reports')->group(function () {
        Route::get('getGeneral', [\App\Http\Controllers\Front\ReportsBranchController::class, 'generalview'])->name('branch.report.viewGeneral');
        Route::get('getGeneral-reports', [\App\Http\Controllers\Front\ReportsBranchController::class, 'getGeneral'])->name('branch.report.getGeneral');
        Route::get('getCalculated', [\App\Http\Controllers\Front\ReportsBranchController::class, 'calculated'])->name('branch.report.calculated');
        Route::get('getCalculated-reports', [\App\Http\Controllers\Front\ReportsBranchController::class, 'getCalculated'])->name('branch.report.getCalculated');
        Route::get('fromFiles', [\App\Http\Controllers\Front\ReportsBranchController::class, 'fromFiles'])->name('branch.report.fromFiles');
        Route::get('getFiles', [\App\Http\Controllers\Front\ReportsBranchController::class, 'getFiles'])->name('branch.report.getFiles');
        Route::get('fixedGeneral', [\App\Http\Controllers\Front\ReportsBranchController::class, 'fixedGeneral'])->name('branch.report.fixedGeneral');
        Route::get('fixedGetGeneral', [\App\Http\Controllers\Front\ReportsBranchController::class, 'fixedGetGeneral'])->name('branch.report.fixedGetGeneral');
    });

});

Route::get('/{slug}', [FrontPageController::class, 'getPage'])->name('getPage');
