@extends('layouts.front')

@section('content')
    <style>
        .scrolling-text-container {
            background-color: #eff5ff;
            border-radius: 4px;
            overflow: hidden;
        }

        /* Inner container styles */
        .scrolling-text-inner {
            display: flex;
            white-space: nowrap;
            font-size: 16px;
            font-weight: 600;
            padding: 8px 0;
        }

        /* Text styles */
        .scrolling-text {
            display: flex;
        }

        .scrolling-text-item {
            padding: 0 30px;
        }

        /* Apply the animation to the text items */
        .scrolling-text-inner > div {
            animation: var(--direction) var(--marquee-speed) linear infinite;
        }

        /* Pause the animation when a user hovers over it */
        .scrolling-text-container:hover .scrolling-text-inner > div {
            animation-play-state: paused;
        }

        /* Setting the Animation using Keyframes */
        @keyframes scroll-left {
            0% {
                transform: translateX(0%);
            }

            100% {
                transform: translateX(-100%);
            }
        }

        @keyframes scroll-right {
            0% {
                transform: translateX(-100%);
            }

            100% {
                transform: translateX(0%);
            }
        }
    </style>
    <div class="text-center mx-auto">
        @php
            $news = \App\Models\NotificationBar::orderBy('updated_at', 'desc')->where('active',1)->get();
            /*
            $str='';
                    foreach($news as $n)
                        {
                           $str.= $n->text.' --  ';
                        }

               {{$str}}
            */
        @endphp
            <!--marquee width="60%" direction="right">

        </marquee-->
    </div>
    <div class="scrolling-text-container">
        <div class="scrolling-text-inner" style="--marquee-speed: 40s; --direction:scroll-left" role="marquee">
            <div class="scrolling-text">
                <div class="scrolling-text-item"></div>
                <div class="scrolling-text-item"></div>
                @foreach($news as $n)
                    <div class="scrolling-text-item">{{$n->text}}</div>
                @endforeach
                <div class="scrolling-text-item"></div>
                <div class="scrolling-text-item"></div>
            </div>
        </div>
    </div>
    <main class="container-fluid listing-container">

        <div class="container">
            <div class="row pt-5 pt-5">
                <div class="col-lg-10 col-md-10 col-sm-12 listing-top-card m-auto">
                    <button class="btn {{ $type != 'history' ? 'active' : '' }}" id="home-btn">
                        Home
                        <br>
                        <span style="font-size: 13px;color: #c00319">Forms Waiting , Incomplete</span>
                    </button>
                    <button class="btn {{ $type == 'history' ? 'active' : '' }}" id="history-btn">
                        History
                        <br>
                        <span style="font-size: 13px;color: #c00319">Forms Expired ,Approved , waiting approved , Done</span>
                    </button>
                </div>
            </div>
            <div class="row pt-5 pt-5 {{ $type == 'history' ? 'd-none' : '' }}" id="home-content">
                <div class="col-lg-10 col-md-10 col-sm-12 listing-card m-auto">
                    <h3>{{ auth('project')->user()->name }}</h3>
                    <div class="content">
                        <div class="row">
                            <div class="select-group col-lg-5 mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="d-flex align-items-center">
                                        <img src="{{ url('front_end/assets/imgs/search-icon.png') }}" alt=""
                                             srcset="">
                                        <input class="form-control p-0" type="text" placeholder="Search"
                                               id="search-home-input">
                                    </div>
                                </div>
                            </div>
                            <div class="select-group col-lg-1 mb-sm-2">
                                <button class="btn btn-dark" id="search-home-button">Search</button>
                            </div>
                            <div class="select-group col-lg-3 col-md-6 col-sm-12 mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="">
                                        <select data-placeholder="Status"
                                                class="js-example-basic-single js-states form-control"
                                                id="home-status-select">
                                            <option value="waiting,incomplete">All</option>
                                            <option value="waiting" class="waiting">
                                                Waiting
                                            </option>
                                            <option value="incomplete" class="incomplete">
                                                Incomplete
                                            </option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="select-group col-lg-3 col-md-6 col-sm-12  mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="d-flex align-items-center justify-content-center">
                                        <input type="text" id="date-picker-home" name="date-picker"
                                               placeholder="Select Date...">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="table-content">
                            <div class="table-head my-3 d-flex justify-content-between align-items-center">
                                <h4 class="fw-bold">
                                    Waiting List
                                </h4>
                                <div class="status-colors d-flex align-items-center">
                                    <div class="waiting-status">
                                        <span class="color"></span>
                                        <span>
                                            Waiting
                                        </span>
                                    </div>
                                    <div class="incomplete-status">
                                        <span class="color"></span>
                                        <span>
                                            Incomplete
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="table-body" id="home-forms-scroll-container">
                                <table class="table table-borderless">
                                    <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Form Name</th>
                                        <th scope="col">description</th>
                                        <th scope="col">Date</th>
                                        <th scope="col">Deadline</th>
                                    </tr>
                                    </thead>
                                    <tbody id="home-tbody-id">

                                    </tbody>
                                </table>
                                <p id="no_more_data_message_home">
                                    No More Data Found...
                                </p>
                                <div id="ajax-load-home">
                                    <i class="fas fa-spinner fa-spin fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row pt-5 pt-5 {{ $type != 'history' ? 'd-none' : '' }}" id="history-content">
                <div class="col-lg-10 col-md-10 col-sm-12 listing-card m-auto">
                    <h3>Project Name</h3>
                    <div class="content">
                        <div class="row">
                            <div class="select-group col-lg-5 mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="d-flex align-items-center">
                                        <img src="{{ url('front_end/assets/imgs/search-icon.png') }}" alt=""
                                             srcset="">
                                        <input class="form-control p-0" type="text" placeholder="Search"
                                               id="search-history-input">
                                    </div>
                                </div>
                            </div>
                            <div class="select-group col-lg-1 mb-sm-2">
                                <button class="btn btn-dark" id="search-history-button">Search</button>
                            </div>
                            <div class="select-group col-lg-3 col-md-6 col-sm-12 mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="">
                                        <select data-placeholder="Status"
                                                class="js-example-basic-single js-states form-control"
                                                id="history-status-select">
                                            <option value="expired,done">All</option>
                                            <option value="expired" class="waiting">
                                                Expired
                                            </option>
                                            <option value="approved" class="approved">
                                                approved
                                            </option>
                                            <option value="waiting approved" class="waiting">
                                                waiting approved
                                            </option>
                                            <option value="done" class="incomplete">
                                                Done
                                            </option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="select-group col-lg-3 col-md-6 col-sm-12  mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="d-flex align-items-center justify-content-center">
                                        <input type="text" id="date-picker-history" name="date-picker"
                                               placeholder="Select Date...">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="table-content">
                            <div class="table-head my-3 d-flex justify-content-between align-items-center">
                                <h4 class="fw-bold">
                                    Waiting List
                                </h4>
                                <div class="status-colors d-flex align-items-center">
                                    <div class="expired-status">
                                        <span class="color"></span>
                                        <span>
                                            Expired
                                        </span>
                                    </div>
                                    <div class="done-status" style="padding-inline-start: 25px">
                                        <span class="color"></span>
                                        <span>
                                            Approved
                                        </span>
                                    </div>
                                    <div class="waiting-status" style="padding-inline-start: 25px">
                                        <span class="color"></span>
                                        <span>
                                            waiting approved
                                        </span>
                                    </div>
                                    <div class="done-status">
                                        <span class="color"></span>
                                        <span>
                                            Done
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="table-body" id="history-forms-scroll-container">
                                <table class="table table-borderless">
                                    <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Form Name</th>
                                        <th scope="col">description</th>
                                        <th scope="col">Date</th>
                                        <th scope="col">Deadline</th>
                                    </tr>
                                    </thead>
                                    <tbody id="history-tbody-id">

                                    </tbody>
                                </table>
                                <p id="no_more_data_message_history">
                                    No More Data Found...
                                </p>
                                <div id="ajax-load-history" class="ajax-load-history">
                                    <i class="fas fa-spinner fa-spin fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection
<style>
    #no_more_data_message_history,
    #no_more_data_message_home,
    #ajax-load-history,
    #ajax-load-home {
        text-align: center;
        position: relative
    }

    #no_more_data_message_history::before,
    #no_more_data_message_home::before {
        content: '';
        position: absolute;
        left: 30%;
        top: 50%;
        transform: translateY(-50%);
        height: 2px;
        width: 3%;
        background-color: #c00319
    }

    #no_more_data_message_history::after,
    #no_more_data_message_home::after {
        content: '';
        position: absolute;
        right: 30%;
        top: 50%;
        transform: translateY(-50%);
        height: 2px;
        width: 3%;
        background-color: #c00319
    }

    #home-forms-scroll-container,
    #history-forms-scroll-container {
        height: 20em;
        overflow: auto;
    }

    /* Hide scrollbar */
    div::-webkit-scrollbar {
        width: 5;
        height: 5;
    }

    /* width */
    ::-webkit-scrollbar {
        width: 8px;
    }

    /* Track */
    ::-webkit-scrollbar-track {
        box-shadow: inset 0 0 5px grey;
        border-radius: 0px;
    }

    /* Handle */
    ::-webkit-scrollbar-thumb {
        background: #c00319;
        border-radius: 0px;
    }

    /* Handle on hover */
    ::-webkit-scrollbar-thumb:hover {
        background: #c00319;
    }
</style>
@section('script')
    <script type="text/javascript">
        var scroll_again_home = 1;
        $('#no_more_data_message_home').hide()
        var pageHome = 1;
        var homeStatus = '&status=waiting,incomplete'
        var homeSearchWord = '&search_word='
        var homeDateRang = '&date_rang='
        var Homeparams = homeStatus;
        $('#home-status-select').change(function () {
            homeSearchWord = '&search_word=' + $('#search-home-input').val();
            homeStatus = '&status=' + $(this).val();
            homeDateRang = '&date_rang=' + $('#date-picker-home').val();
            Homeparams = homeStatus + homeSearchWord + homeDateRang;
            pageHome = 1;
            loadMoreDataHome(pageHome, Homeparams, 'replacement');
        })
        $('#date-picker-home').on('apply.daterangepicker', function (ev, picker) {
            $(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
            homeSearchWord = '&search_word=' + $('#search-home-input').val();
            homeStatus = '&status=' + $('#home-status-select').val();
            homeDateRang = '&date_rang=' + $(this).val();
            Homeparams = homeStatus + homeSearchWord + homeDateRang;
            pageHome = 1;
            loadMoreDataHome(pageHome, Homeparams, 'replacement');
        });

        $('#date-picker-home').on('cancel.daterangepicker', function (ev, picker) {
            $(this).val('');
            homeSearchWord = '&search_word=' + $('#search-home-input').val();
            homeStatus = '&status=' + $('#home-status-select').val();
            homeDateRang = '&date_rang=' + $(this).val();
            Homeparams = homeStatus + homeSearchWord + homeDateRang;
            pageHome = 1;
            loadMoreDataHome(pageHome, Homeparams, 'replacement');
        });
        $('#search-home-button').click(function () {
            homeSearchWord = '&search_word=' + $('#search-home-input').val();
            homeStatus = '&status=' + $('#home-status-select').val();
            homeDateRang = '&date_rang=' + $('#date-picker-home').val();
            Homeparams = homeStatus + homeSearchWord + homeDateRang;
            pageHome = 1;
            loadMoreDataHome(pageHome, Homeparams, 'replacement');
        })
        loadMoreDataHome(pageHome, Homeparams, 'append');
        $('#home-forms-scroll-container').scroll(function () {
            console.log(scroll_again_home);
            if ($(this).scrollTop() + $(this).innerHeight() >= $(this)[0].scrollHeight &&
                scroll_again_home == 1) {
                pageHome++;
                loadMoreDataHome(pageHome, Homeparams, 'append');
            }
        });

        function loadMoreDataHome(pageHome, Homeparams, homeAppendReplace) {
            $.ajax({
                url: '{{ route('getProjectForms') }}?page=' +
                    pageHome + Homeparams,
                type: "get",
                beforeSend: function () {
                    $('#ajax-load-home').show();
                }
            })
                .done(function (data) {
                    if (!data) {
                        $('#no_more_data_message_home').show()
                        $('#ajax-load-home').hide();
                        if (homeAppendReplace == 'replacement') {
                            $("#home-tbody-id").html('');
                            scroll_again_home = 1;
                        }
                        scroll_again_home = 0;
                        console.log(scroll_again_home);
                        return;
                    }
                    $('#ajax-load-home').hide();
                    if (homeAppendReplace == 'append') {
                        $("#home-tbody-id").append(data);
                    } else {
                        $("#home-tbody-id").html(data);
                        scroll_again_home = 1;
                    }


                })
                .fail(function (jqXHR, ajaxOptions, thrownError) {
                    alert('server not responding...');

                });

        }
    </script>
    <script type="text/javascript">
        var scroll_again_history = 1;
        $('#no_more_data_message_history').hide()
        var pageHistory = 1;
        var historyStatus = '&status=expired,done,approved,waiting approved'
        var historySearchWord = '&search_word='
        var historyDateRang = '&date_rang='
        var Historyeparams = historyStatus;
        $('#history-status-select').change(function () {
            historySearchWord = '&search_word=' + $('#search-history-input').val();
            historyStatus = '&status=' + $(this).val();
            historyDateRang = '&date_rang=' + $('#date-picker-history').val();
            Historyeparams = historyStatus + historySearchWord + historyDateRang;
            pageHistory = 1;
            loadMoreDataHistory(pageHistory, Historyeparams, 'replacement');
        })
        $('#date-picker-history').on('apply.daterangepicker', function (ev, picker) {
            $(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
            historySearchWord = '&search_word=' + $('#search-history-input').val();
            historyStatus = '&status=' + $('#history-status-select').val();
            historyDateRang = '&date_rang=' + $(this).val();
            Historyeparams = historyStatus + historySearchWord + historyDateRang;
            pageHistory = 1;
            loadMoreDataHistory(pageHistory, Historyeparams, 'replacement');
        });

        $('#date-picker-history').on('cancel.daterangepicker', function (ev, picker) {
            $(this).val('');
            historySearchWord = '&search_word=' + $('#search-history-input').val();
            historyStatus = '&status=' + $('#history-status-select').val();
            historyDateRang = '&date_rang=' + $(this).val();
            Historyeparams = historyStatus + historySearchWord + historyDateRang;
            pageHistory = 1;
            loadMoreDataHistory(pageHistory, Historyeparams, 'replacement');
        });
        $('#search-history-button').click(function () {
            historySearchWord = '&search_word=' + $('#search-history-input').val();
            historyStatus = '&status=' + $('#history-status-select').val();
            historyDateRang = '&date_rang=' + $('#date-picker-history').val();
            Historyeparams = historyStatus + historySearchWord + historyDateRang;
            pageHistory = 1;
            loadMoreDataHistory(pageHistory, Historyeparams, 'replacement');
        })
        loadMoreDataHistory(pageHistory, Historyeparams, 'append');
        $('#history-forms-scroll-container').scroll(function () {
            if ($(this).scrollTop() + $(this).innerHeight() >= $(this)[0].scrollHeight &&
                scroll_again_history == 1) {
                pageHistory++;
                loadMoreDataHistory(pageHistory, Historyeparams, 'append');
            }
        });

        function loadMoreDataHistory(pageHistory, Historyeparams, historyAppendReplace) {
            $.ajax({
                url: '{{ route('getProjectForms') }}?page=' +
                        pageHistory + Historyeparams,
                    type: "get",
                    beforeSend: function() {
                        $('#ajax-load-history').show();
                    }
                })
                .done(function(data) {
                    if (!data) {
                        $('#no_more_data_message_history').show()
                        $('#ajax-load-history').hide();
                        if (historyAppendReplace == 'replacement') {
                            $("#history-tbody-id").html('');
                            scroll_again_history = 1;
                        }
                        scroll_again_history = 0;
                        return;
                    }
                    $('#ajax-load-history').hide();
                    if (historyAppendReplace == 'append') {
                        $("#history-tbody-id").append(data);
                    } else {
                        $("#history-tbody-id").html(data);
                        scroll_again_history = 1;
                    }


                })
                .fail(function(jqXHR, ajaxOptions, thrownError) {
                    alert('server not responding...');

                });

        }
    </script>
@endsection
