@extends('layouts.front')
@section('content')
    <main class="container-fluid view-container">
        <div class="container" id="remove-on-submition">
            <div class="row pt-5 pt-5">
                <div class="col-lg-10 col-md-10 col-sm-12 view-card m-auto">
                    <div class="row w-50 ms-auto align-items-center">
                        <div class="col-md-10 mb-5 text-end">
                            @php
                                $percentage = ($currentInputsNum / $totalInputs) * 100;
                            @endphp
                            <div class="progress" style="height:5px">
                                <div class="progress-bar bg-danger" role="progressbar" style="width: {{ $percentage }}%"
                                     aria-valuenow="{{ $totalInputs }}" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
                        <div class="col-md-2 mb-5 text-end">
                            <span>{{ $currentInputsNum }}/{{ $totalInputs }}</span>
                        </div>
                    </div>
                    <h3>{{ $projectForm->name }}</h3>

                    <p>
                        {{$projectForm->desc }}
                    </p>
                    <div class="content">
                        <div class="row">
                            <h5 class="text-end">{{ $projectForm->created_at }}</h5>
                        </div>
                        <div class="form-content">
                            <div class="d-flex justify-content-between">
                                <div class="attached-title d-flex justify-content-center">
                                    <h5>
                                        Attached Files
                                    </h5>
                                </div>
                            </div>
                            <div class="attached-data">
                                <div class="row align-items-center">
                                    @foreach ($projectForm->formFiles as $file)
                                        @switch($file->type)
                                            @case('image/png')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox="gallery">
                                                        <img width="50px" height="50px"
                                                             src="{{ url($file->file_path) }}"
                                                             alt="">
                                                    </a>
                                                </div>
                                                @break

                                            @case('image/jpg')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox="gallery">
                                                        <img width="50px" height="50px"
                                                             src="{{ url($file->file_path) }}"
                                                             alt="">
                                                    </a>
                                                </div>
                                                @break

                                            @case('image/jpeg')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox="gallery">
                                                        <img width="50px" height="50px"
                                                             src="{{ url($file->file_path) }}"
                                                             alt="">
                                                    </a>
                                                </div>
                                                @break

                                            @case('application/pdf')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox
                                                       data-type="iframe">
                                                        <img src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                             alt="">
                                                    </a>
                                                </div>
                                                @break

                                            @default
                                        @endswitch
                                    @endforeach


                                </div>
                            </div>
                        </div>
                        <form action="{{ route('front.fixed.submit',$form_id) }}" method="POST" id="submit-form-id"
                              enctype='multipart/form-data'>
                            @csrf
                            <input type="hidden" name="project_form_id" value="{{ $form_id }}">
                            <input type="hidden" name="nextPage" value="{{ $nextPage }}">
                            <input type="hidden" name="prevPage" value="{{ $prevPage }}">
                            <input type="hidden" name="show_submit" value="{{ $show_submit }}">
                            <input type="hidden" name="totalPages" value="{{ $totalPages }}">
                            <div class="form-content">
                                <div class="form-data">
                                    <div class="row">
                                        @foreach ($formInputs as $key => $input)
                                            @switch($input->input_type)
                                                @case('text')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="text-input"
                                                               class="form-label">{{ $input->label }}</label>
                                                        <input name="inputs[{{ $input->id }}][answer]" type="text"
                                                               placeholder="{{ $input->placeholder }}"
                                                               id="text-input{{ $input->id  }}"
                                                               value="{{ isset($myforms[$input->id])&&$myforms[$input->id]['answer']!=null?$myforms[$input->id]['answer']:$input->value}}"
                                                               class="form-control">
                                                        <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                               value="{{ $input->input_type }}">
                                                    </div>
                                                    @break

                                                @case('number')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="number-input"
                                                               class="form-label">{{ $input->label }}</label>
                                                        <input type="number" step="1"
                                                               value="{{  isset($myforms[$input->id])&&$myforms[$input->id]['answer']!=null?$myforms[$input->id]['answer']:$input->value }}"
                                                               id="number-input{{ $input->id }}"
                                                               placeholder="{{ $input->placeholder }}"
                                                               class="form-control numberInput"
                                                               name="inputs[{{ $input->id }}][answer]">
                                                        <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                               value="{{$input->input_type}}">
                                                    </div>
                                                    @break

                                                @case('textarea')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="textarea-input"
                                                               class="form-label">{{ $input->label }}</label>
                                                        <textarea class="form-control resize-none"
                                                                  name="inputs[{{ $input->id }}][answer]"
                                                                  id="textarea-input{{ $key }}" rows="3"
                                                                  placeholder="{{ $input->placeholder }}">{{isset($myforms[$input->id])&&$myforms[$input->id]['answer']!=null?$myforms[$input->id]['answer']: $input->value}}</textarea>
                                                        <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                               value="{{$input->input_type }}">
                                                    </div>
                                                    @break

                                                @case('file')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3 custom-file">
                                                        <label for="number-input"
                                                               class="form-label">{{ $input->label }}</label>
                                                        <input type="file" id="file-input{{ $input->id }}"
                                                               name="inputs[{{ $input->id }}][answer]"
                                                               class="form-control custom-file-input">
                                                        <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                               value="{{ $input->input_type }}">
                                                        <img width="60px" class="img" id="file-reader-image" src=""
                                                             alt="">
                                                        <a href="#" id="display-pdf-file"
                                                           style="display: none;text-decoration: none" data-fancybox
                                                           data-type="iframe">
                                                            <img src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                                 alt="">
                                                        </a>
                                                        @if (isset($myforms[$input->id])&&$myforms[$input->id]['answer']!=null)
                                                            @if ($myforms[$input->id]['file_type'] == 'application/pdf')
                                                                <a id="old-pdf-file"
                                                                   href="{{ url($myforms[$input->id]['answer']) }}"
                                                                   data-fancybox data-type="iframe">
                                                                    <img
                                                                        src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                                        alt="">
                                                                </a>
                                                            @else
                                                                <a href="{{ url($myforms[$input->id]['answer']) }}"
                                                                   data-fancybox="gallery">
                                                                    <img class="old-img" width="60px"
                                                                         src="{{ url($myforms[$input->id]['answer']) }}"
                                                                         alt="">
                                                                </a>
                                                            @endif
                                                        @endif
                                                    </div>
                                                    @break
                                                @case('checkbox')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="textarea-input"
                                                               class="form-label">{{ $input->label }}</label>
                                                        @if($input->inputsElemnts != null)
                                                            @foreach($input->inputsElemnts as $el)
                                                                <div class="checkbox-group">
                                                                    <input type="checkbox" id="{{$el->name }}"
                                                                           name="inputs[{{ $input->id }}][answer][]"
                                                                           class="filled-in chk-col-danger checkbox-input"
                                                                           value="{{$el->id}}"
                                                                    @if(isset($myforms[$input->id]) && $myforms[$input->id]['answer'] !=null)
                                                                        {{in_array($el->id,json_decode($myforms[$input->id]['answer'],true)) ?'checked':''}}
                                                                        @else
                                                                        {{ $el->name == $input->value ? 'checked':''}}
                                                                        @endif


                                                                    />
                                                                    <label for="{{$el->name}}"
                                                                           class="form-label checkbox-label">{{ $el->name }}</label>
                                                                    <input type="hidden"
                                                                           name="inputs[{{ $input->id }}][type]"
                                                                           value="{{$input->input_type }}">

                                                                </div>

                                                            @endforeach
                                                        @endif

                                                    </div>
                                                    @break
                                                @case('radio')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="textarea-input"
                                                               class="form-label">{{ $input->label }}</label>
                                                        @if($input->inputsElemnts != null)
                                                            @foreach($input->inputsElemnts as $el)
                                                                <div class="checkbox-group">
                                                                    <input type="radio" id="{{$el->name }}"
                                                                           name="inputs[{{ $input->id }}][answer]"
                                                                           class="filled-in chk-col-danger checkbox-input"
                                                                           value="{{$el->id}}"
                                                                    @if(isset($myforms[$input->id]) && $myforms[$input->id]['answer'] !=null)
                                                                        {{$el->id == $myforms[$input->id]['answer'] ?'checked':''}}
                                                                        @else
                                                                        {{ $el->name == $input->value ?'checked':''}}
                                                                        @endif
                                                                    />
                                                                    <label for="{{$el->name}}"
                                                                           class="form-label checkbox-label">{{ $el->name }}</label>
                                                                    <input type="hidden"
                                                                           name="inputs[{{ $input->id }}][type]"
                                                                           value="{{ $input->input_type }}">

                                                                </div>

                                                            @endforeach
                                                        @endif

                                                    </div>
                                                    @break

                                                @default
                                            @endswitch
                                        @endforeach

                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                @if ($prevPage != 0)
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper">
                                        <button type="submit" name="submit_type" value="prev"
                                                class="btn save-btn d-block py-2 fs-5">Prev
                                        </button>
                                    </div>
                                @endif
                                @if ($show_submit == true)
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper ms-auto">
                                        <button type="submit" name="submit_type" value="submit" id="submit_button"
                                                class="btn save-btn d-block py-2 fs-5">Save
                                        </button>
                                    </div>
                                @else
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper ms-auto">
                                        <button type="submit" name="submit_type" value="next"
                                                class="btn save-btn d-block py-2 fs-5">Next
                                        </button>
                                    </div>
                                @endif

                            </div>
                        </form>
                    </div>

                </div>


            </div>
        </div>
    </main>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            $('[data-fancybox="gallery"]').fancybox({
                loop: true,
                keyboard: true,
                arrows: true,
                infobar: true,
                buttons: [
                    "thumbs",
                    "close",
                    "download",
                ]
            });
            var fileTypes = ['jpg', 'jpeg', 'png', 'pdf'];
            $(".custom-file-input").change(function () {
                var img_src = jQuery(this).parents('.custom-file').find(
                    ".img");
                jQuery(this).parents('.custom-file').find(
                    ".old-img").css('display', 'none');
                if (typeof (FileReader) != "undefined") {
                    var reader = new FileReader();
                    var extension = $(this)[0].files[0].name.split('.').pop().toLowerCase();
                    if (extension == "pdf") {
                        reader.onload = () => {
                            let json = JSON.stringify({
                                dataURL: reader.result
                            });
                            let fileURL = JSON.parse(json).dataURL;
                            $('#old-pdf-file').hide();
                            $('#file-reader-image').hide();
                            $('#display-pdf-file').show();
                            $('#display-pdf-file').attr('href', fileURL);
                        }
                    } else {
                        reader.onload = function (e) {
                            $('#old-pdf-file').hide();
                            $('#display-pdf-file').hide();
                            $('#file-reader-image').show();
                            img_src.attr("src", e.target.result);
                        }
                    }

                    reader.readAsDataURL($(this)[0].files[0]);
                } else {
                    alert("This browser does not support FileReader.");
                }

            });
        })
    </script>

    <script>
        // الحصول على جميع العناصر التي تحتوي على الفئة "numberInput"
        var numberInputs = document.getElementsByClassName('numberInput');

        // إضافة مستمع للأحداث لكل عنصر من العناصر
        Array.from(numberInputs).forEach(function(input) {
            input.addEventListener('input', function() {
                if (this.value < 0) {
                    this.value = 0;
                }
            });

            input.addEventListener('keypress', function(event) {
                if (event.key === '-' || event.key === 'e') {
                    event.preventDefault();
                    this.value = 0;
                }
            });
        });
    </script>

@endsection
