@extends('layouts.front')

@section('content')
    <style>
        .listing-container .listing-card .listing-header {
            padding-bottom: 15px;
            border-bottom: 1px solid var(--Dark-Gray);
        }
        .listing-container .listing-card h3 {
            border-bottom: unset;
            text-align: start;
            padding-bottom: 0;
            width: auto;
            margin: unset;
        }
    </style>
    <main class="container-fluid listing-container">
        <div class="container">
            <div class="row pt-5 pt-5">
                <div class="col-lg-10 col-md-10 col-sm-12 listing-top-card m-auto">
                    <button class="btn {{ $type == 'general' ? 'active' : '' }}" id="home-btn">
                        General
                        <br>
                        <span style="font-size: 13px;color: #c00319">Forms Waiting , Incomplete , Expired , waiting approved , Approved  , Done</span>
                    </button>
                    <button class="btn {{ $type == 'fixed' ? 'active' : '' }}" id="history-btn">
                        Fixed
                        <br>
                        <span style="font-size: 13px;color: #c00319">Forms OPen , Waiting , Approved  , Done</span>
                    </button>
                </div>
            </div>
            <div class="row pt-5 pt-5 {{ $type != 'general' ? 'd-none' : '' }}" id="home-content">
                <div class="col-lg-10 col-md-10 col-sm-12 listing-card m-auto">
                    <div class="listing-header d-flex align-items-center justify-content-between">
                        <h3>General</h3>
                        <div class="dropdown">
                            <button class="btn btn-dark dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                Reports
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                <li><a class="dropdown-item" href="{{route('branch.report.viewGeneral')}}">General Report</a></li>
                                <li><a class="dropdown-item" href="{{route('branch.report.calculated')}}">Calculated Report</a></li>
                                <li><a class="dropdown-item" href="{{route('branch.report.fromFiles')}}">files Report</a></li>

                            </ul>
                        </div>
                    </div>

                    <div class="content">
                        <div class="row">
                            <div class="select-group col-lg-2 mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="d-flex align-items-center">
                                        <img src="{{ url('front_end/assets/imgs/search-icon.png') }}" alt=""
                                             srcset="">
                                        <input class="form-control p-0" type="text" placeholder="Search"
                                               id="search-home-input">
                                    </div>
                                </div>
                            </div>
                            <div class="select-group col-lg-1 mb-sm-2">
                                <button class="btn btn-dark" id="search-home-button">Search</button>
                            </div>
                            <div class="select-group col-lg-3 col-md-6 col-sm-12 mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="">
                                        <select data-placeholder="Project"
                                                class="js-example-basic-single js-states form-control" id="ProjectsInFromGeneral">
                                            <option value=" ">All</option>
                                            @foreach($projects as $pro)
                                                <option value="{{$pro->id}}">{{$pro->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="select-group col-lg-3 col-md-6 col-sm-12 mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="">
                                        <select data-placeholder="Status"
                                                class="js-example-basic-single js-states form-control" id="home-status-select">
                                            <option value=" ">All</option>
                                            <option value="waiting" class="waiting">
                                                Waiting</option>
                                            <option value="incomplete" class="incomplete">
                                                Incomplete</option>
                                            <option value="waiting approved" class="waiting approved">
                                                waiting approved</option>
                                            <option value="expired" class="waiting">
                                                Expired</option>
                                            <option value="approved" class="approved">
                                                approved</option>
                                            <option value="done" class="incomplete">
                                                Done</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="select-group col-lg-2 col-md-6 col-sm-12  mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="d-flex align-items-center justify-content-center">
                                        <input type="text" id="date-picker-home" name="date-picker"
                                               placeholder="Select Date...">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="table-content">
                            <div class="table-head my-3 d-flex justify-content-between align-items-center">
                                <h4 class="fw-bold">
                                   List General
                                </h4>
                                <div class="status-colors d-flex align-items-center">
                                    <div class="waiting-status" style="padding-inline-start: 25px">
                                        <span class="color" style="background-color: black"></span>
                                        <span>
                                            Waiting
                                        </span>
                                    </div>
                                    <div class="incomplete-status" style="padding-inline-start: 25px">
                                        <span class="color"></span>
                                        <span>
                                            Incomplete
                                        </span>
                                    </div>
                                    <div class="expired-status" style="padding-inline-start: 25px">
                                        <span class="color"></span>
                                        <span>
                                            Expired
                                        </span>
                                    </div>
                                    <div class="done-status" style="padding-inline-start: 25px">
                                        <span class="color"></span>
                                        <span>
                                            Done
                                        </span>
                                    </div>
                                    <div class="done-status" style="padding-inline-start: 25px">
                                        <span class="color"></span>
                                        <span>
                                            Approved
                                        </span>
                                    </div>
                                    <div class="waiting-status" style="padding-inline-start: 25px">
                                        <span class="color" ></span>
                                        <span>
                                            waiting approved
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="table-body" id="home-forms-scroll-container">
                                <table class="table table-borderless">
                                    <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Form Name</th>
                                        <th scope="col">status</th>
                                        <th scope="col">Project Name</th>
                                        <th scope="col">Date</th>
                                        <th scope="col">Deadline</th>
                                    </tr>
                                    </thead>
                                    <tbody id="home-tbody-id">

                                    </tbody>
                                </table>
                                <p id="no_more_data_message_home">
                                    No More Data Found...
                                </p>
                                <div id="ajax-load-home">
                                    <i class="fas fa-spinner fa-spin fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row pt-5 pt-5 {{ $type != 'fixed' ? 'd-none' : '' }}" id="history-content">
                <div class="col-lg-10 col-md-10 col-sm-12 listing-card m-auto">
                    <div class="listing-header d-flex align-items-center justify-content-between">
                        <h3>Fixed</h3>
                        <div class="dropdown">
                            <button class="btn btn-dark dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                                Reports
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                <li><a class="dropdown-item" href="{{route('branch.report.fixedGeneral')}}">General Report</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="content">
                        <div class="row">
                            <div class="select-group col-lg-2 mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="d-flex align-items-center">
                                        <img src="{{ url('front_end/assets/imgs/search-icon.png') }}" alt=""
                                             srcset="">
                                        <input class="form-control p-0" type="text" placeholder="Search"
                                               id="search-history-input">
                                    </div>
                                </div>
                            </div>
                            <div class="select-group col-lg-1 mb-sm-2">
                                <button class="btn btn-dark" id="search-history-button">Search</button>
                            </div>
                            <div class="select-group col-lg-3 col-md-6 col-sm-12 mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="">
                                        <select data-placeholder="Project"
                                                class="js-example-basic-single js-states form-control" id="ProjectsInFromFixed">
                                            <option value=" ">All</option>
                                            @foreach($projects as $pro)
                                                <option value="{{$pro->id}}">{{$pro->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="select-group col-lg-3 col-md-6 col-sm-12 mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="">
                                        <select data-placeholder="Status"
                                                class="js-example-basic-single js-states form-control"
                                                id="history-status-select">
                                            <option value=" ">All</option>
                                            <option value="open" class="waiting">
                                                Open</option>
                                            <option value="waiting" class="waiting">
                                                waiting</option>
                                            <option value="approved" class="approved">
                                                approved</option>
                                            <option value="done" class="done">
                                                done</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="select-group col-lg-3 col-md-6 col-sm-12  mb-sm-2">
                                <div class="group-wrapper">
                                    <div class="d-flex align-items-center justify-content-center">
                                        <input type="text" id="date-picker-history" name="date-picker"
                                               placeholder="Select Date...">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="table-content">
                            <div class="table-head my-3 d-flex justify-content-between align-items-center">
                                <h4 class="fw-bold">
                                    List Fixed
                                </h4>
                                <div class="status-colors d-flex align-items-center">
                                    <div class="incomplete-status" style="padding-inline-start: 25px">
                                        <span class="color"></span>
                                        <span>
                                            Open
                                        </span>
                                    </div>
                                    <div class="waiting-status" style="padding-inline-start: 25px">
                                        <span class="color"></span>
                                        <span>
                                            Waiting
                                        </span>
                                    </div>
                                    <div class="done-status" style="padding-inline-start: 25px">
                                        <span class="color"></span>
                                        <span>
                                            Approved
                                        </span>
                                    </div>
                                    <div class="expired-status" style="padding-inline-start: 25px">
                                        <span class="color"></span>
                                        <span>
                                            Rejected
                                        </span>
                                    </div>
                                    <div class="done-status" style="padding-inline-start: 25px">
                                        <span class="color"></span>
                                        <span>
                                            Done
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="table-body" id="history-forms-scroll-container">
                                <table class="table table-borderless">
                                    <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Form Name</th>
                                        <th scope="col">Project Name</th>
                                        <th scope="col">status</th>
                                        <th scope="col">Date</th>

                                    </tr>
                                    </thead>
                                    <tbody id="history-tbody-id">

                                    </tbody>
                                </table>
                                <p id="no_more_data_message_history">
                                    No More Data Found...
                                </p>
                                <div id="ajax-load-history" class="ajax-load-history">
                                    <i class="fas fa-spinner fa-spin fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection
<style>
    #no_more_data_message_history,
    #no_more_data_message_home,
    #ajax-load-history,
    #ajax-load-home {
        text-align: center;
        position: relative
    }

    #no_more_data_message_history::before,
    #no_more_data_message_home::before {
        content: '';
        position: absolute;
        left: 30%;
        top: 50%;
        transform: translateY(-50%);
        height: 2px;
        width: 3%;
        background-color: #c00319
    }

    #no_more_data_message_history::after,
    #no_more_data_message_home::after {
        content: '';
        position: absolute;
        right: 30%;
        top: 50%;
        transform: translateY(-50%);
        height: 2px;
        width: 3%;
        background-color: #c00319
    }

    #home-forms-scroll-container,
    #history-forms-scroll-container {
        height: 20em;
        overflow: auto;
    }

    /* Hide scrollbar */
    div::-webkit-scrollbar {
        width: 5px;
        height: 5px;
    }

    /* width */
    ::-webkit-scrollbar {
        width: 8px;
    }

    /* Track */
    ::-webkit-scrollbar-track {
        box-shadow: inset 0 0 5px grey;
        border-radius: 0px;
    }

    /* Handle */
    ::-webkit-scrollbar-thumb {
        background: #c00319;
        border-radius: 0px;
    }

    /* Handle on hover */
    ::-webkit-scrollbar-thumb:hover {
        background: #c00319;
    }
</style>
@section('script')
    <script type="text/javascript">
        $('#ProjectsInFromGeneral').select2();
        $('#home-status-select').select2();
        $('#ProjectsInFromFixed').select2();
        $('#history-status-select').select2();
        var scroll_again_home = 1;
        $('#no_more_data_message_home').hide()
        var pageHome = 1;
        var homeStatus = '&status='
        var homeSearchWord = '&search_word='
        var homeDateRang = '&date_rang='
        var projectId = '&projectId='
        var Homeparams = homeStatus;
        $('#home-status-select').change(function() {
            homeSearchWord = '&search_word=' + $('#search-home-input').val();
            homeStatus = '&status=' + $(this).val();
            homeDateRang = '&date_rang=' + $('#date-picker-home').val();
            projectId = '&projectId=' + $('#ProjectsInFromGeneral').val();
            Homeparams = homeStatus + homeSearchWord + homeDateRang + projectId;
            pageHome = 1;
            loadMoreDataHome(pageHome, Homeparams, 'replacement');
        })
        $('#ProjectsInFromGeneral').change(function() {
            homeSearchWord = '&search_word=' + $('#search-home-input').val();
            homeStatus = '&status=' + $('#home-status-select').val();
            homeDateRang = '&date_rang=' + $('#date-picker-home').val();
            projectId = '&projectId=' + $(this).val();
            Homeparams = homeStatus + homeSearchWord + homeDateRang + projectId;
            pageHome = 1;
            loadMoreDataHome(pageHome, Homeparams, 'replacement');
        })
        $('#date-picker-home').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
            homeSearchWord = '&search_word=' + $('#search-home-input').val();
            homeStatus = '&status=' + $('#home-status-select').val();
            homeDateRang = '&date_rang=' + $(this).val();
            projectId = '&projectId=' + $('#ProjectsInFromGeneral').val();
            Homeparams = homeStatus + homeSearchWord + homeDateRang +projectId;
            pageHome = 1;
            loadMoreDataHome(pageHome, Homeparams, 'replacement');
        });

        $('#date-picker-home').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            homeSearchWord = '&search_word=' + $('#search-home-input').val();
            homeStatus = '&status=' + $('#home-status-select').val();
            homeDateRang = '&date_rang=' + $(this).val();
            projectId = '&projectId=' + $('#ProjectsInFromGeneral').val();
            Homeparams = homeStatus + homeSearchWord + homeDateRang + projectId;
            pageHome = 1;
            loadMoreDataHome(pageHome, Homeparams, 'replacement');
        });
        $('#search-home-button').click(function() {
            homeSearchWord = '&search_word=' + $('#search-home-input').val();
            homeStatus = '&status=' + $('#home-status-select').val();
            homeDateRang = '&date_rang=' + $('#date-picker-home').val();
            projectId = '&projectId=' + $('#ProjectsInFromGeneral').val();
            Homeparams = homeStatus + homeSearchWord + homeDateRang +projectId;
            pageHome = 1;
            loadMoreDataHome(pageHome, Homeparams, 'replacement');
        })
        loadMoreDataHome(pageHome, Homeparams, 'append');
        $('#home-forms-scroll-container').scroll(function() {
            console.log(scroll_again_home);
            if ($(this).scrollTop() + $(this).innerHeight() >= $(this)[0].scrollHeight &&
                scroll_again_home == 1) {
                pageHome++;
                loadMoreDataHome(pageHome, Homeparams, 'append');
            }
        });

        function loadMoreDataHome(pageHome, Homeparams, homeAppendReplace) {
            $.ajax({
                url: '{{ route('branch.front.form') }}?page=' +
                    pageHome + Homeparams,
                type: "get",
                beforeSend: function() {
                    $('#ajax-load-home').show();
                }
            })
                .done(function(data) {
                    if (!data) {
                        $('#no_more_data_message_home').show()
                        $('#ajax-load-home').hide();
                        if (homeAppendReplace == 'replacement') {
                            $("#home-tbody-id").html('');
                            scroll_again_home = 1;
                        }
                        scroll_again_home = 0;
                        console.log(scroll_again_home);
                        return;
                    }
                    $('#ajax-load-home').hide();
                    if (homeAppendReplace == 'append') {
                        $("#home-tbody-id").append(data);
                    } else {
                        $("#home-tbody-id").html(data);
                        scroll_again_home = 1;
                    }


                })
                .fail(function(jqXHR, ajaxOptions, thrownError) {
                    alert('server not responding...');

                });

        }
    </script>
    <script type="text/javascript">
        var scroll_again_history = 1;
        $('#no_more_data_message_history').hide()
        var pageHistory = 1;
        var historyStatus = '&status='
        var historySearchWord = '&search_word='
        var historyDateRang = '&date_rang='
        var project = '&projectId='
        var Historyeparams = historyStatus;
        $('#history-status-select').change(function() {
            historySearchWord = '&search_word=' + $('#search-history-input').val();
            historyStatus = '&status=' + $(this).val();
            historyDateRang = '&date_rang=' + $('#date-picker-history').val();
            project = '&projectId=' + $('#ProjectsInFromFixed').val();
            Historyeparams = historyStatus + historySearchWord + historyDateRang + project;
            pageHistory = 1;
            loadMoreDataHistory(pageHistory, Historyeparams, 'replacement');
        })
        $('#ProjectsInFromFixed').change(function() {
            historySearchWord = '&search_word=' + $('#search-history-input').val();
            historyStatus = '&status=' + $('#history-status-select').val();
            historyDateRang = '&date_rang=' + $('#date-picker-history').val();
            project = '&projectId=' + $(this).val();
            Historyeparams = historyStatus + historySearchWord + historyDateRang + project;
            pageHistory = 1;
            loadMoreDataHistory(pageHistory, Historyeparams, 'replacement');
        })
        $('#date-picker-history').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
            historySearchWord = '&search_word=' + $('#search-history-input').val();
            historyStatus = '&status=' + $('#history-status-select').val();
            historyDateRang = '&date_rang=' + $(this).val();
            project = '&projectId=' + $('#ProjectsInFromFixed').val();
            Historyeparams = historyStatus + historySearchWord + historyDateRang + project;
            pageHistory = 1;
            loadMoreDataHistory(pageHistory, Historyeparams, 'replacement');
        });

        $('#date-picker-history').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            historySearchWord = '&search_word=' + $('#search-history-input').val();
            historyStatus = '&status=' + $('#history-status-select').val();
            historyDateRang = '&date_rang=' + $(this).val();
            project = '&projectId=' + $('#ProjectsInFromFixed').val();
            Historyeparams = historyStatus + historySearchWord + historyDateRang + project;
            pageHistory = 1;
            loadMoreDataHistory(pageHistory, Historyeparams, 'replacement');
        });
        $('#search-history-button').click(function() {
            historySearchWord = '&search_word=' + $('#search-history-input').val();
            historyStatus = '&status=' + $('#history-status-select').val();
            historyDateRang = '&date_rang=' + $('#date-picker-history').val();
            project = '&projectId=' + $('#ProjectsInFromFixed').val();
            Historyeparams = historyStatus + historySearchWord + historyDateRang + project;
            pageHistory = 1;
            loadMoreDataHistory(pageHistory, Historyeparams, 'replacement');
        })
        loadMoreDataHistory(pageHistory, Historyeparams, 'append');
        $('#history-forms-scroll-container').scroll(function() {
            if ($(this).scrollTop() + $(this).innerHeight() >= $(this)[0].scrollHeight -5 &&
                scroll_again_history == 1) {
                pageHistory++;
                loadMoreDataHistory(pageHistory, Historyeparams, 'append');
            }

        });

        function loadMoreDataHistory(pageHistory, Historyeparams, historyAppendReplace) {
            $.ajax({
                url: '{{ route('branch.front.fixed') }}?page=' +
                    pageHistory + Historyeparams,
                type: "get",
                beforeSend: function() {
                    $('#ajax-load-history').show();
                }
            }) .done(function(data) {
                if (!data) {
                    $('#no_more_data_message_history').show()
                    $('#ajax-load-history').hide();
                    if (historyAppendReplace == 'replacement') {
                        $("#history-tbody-id").html('');
                        scroll_again_history = 1;
                    }
                    scroll_again_history = 0;
                    return;
                }
                $('#ajax-load-history').hide();
                if (historyAppendReplace == 'append') {
                    $("#history-tbody-id").append(data);
                } else {
                    $("#history-tbody-id").html(data);
                    scroll_again_history = 1;
                }


            })
                .fail(function(jqXHR, ajaxOptions, thrownError) {
                    alert('server not responding...');

                });

        }
    </script>
@endsection
