@forelse ($forms as $key => $form)
    <tr>
        <td>{{ $loop->iteration + (($forms->currentPage() ?? 0 ) - 1) * (($forms->perPage()?? 0) + 1 )}}</td>
        <td>{{ $form->form->name }}</td>
        <td>{{ $form->status }}</td>
        <td>{{ $form->project->name }}</td>
        <td>
            {{ date('M j, Y', strtotime($form->created_at)) }}</td>
        <td>{{ date('M j, Y', strtotime($form->expiration_date)) }}</td>
        <td class="text-end">
            <a style="text-decoration: none" href="{{ route('branch.front.formView', $form->id) }}" class="view-button {{$color[$form->status]}}">
                View
            </a>
            &nbsp;
            <a onclick="return confirm('Are you sure?')"  style="text-decoration: none" href="{{ route('branch.from.del', $form->id) }}" class="view-button bg-danger">
                Delete
            </a>

        </td>
    </tr>

@empty
@endforelse
