@extends('layouts.front')
@section('content')
    <main class="container-fluid view-container">
        <div class="container">
            <div class="row pt-5 pt-5">
                <div class="col-lg-10 col-md-10 col-sm-12 view-card m-auto">
                    <div class="row w-50 ms-auto align-items-center">
                        @if($projectForm->form->approved == 1 && in_array($projectForm->status,['waiting approved']))
                        <div class="row col-12 ">
                            <div class="col-lg-6 col-md-6 col-sm-12 save-btn-wrapper">
                                <a href="{{ route('branch.front.ChangeStatusFrom', ['id' => $projectForm->id, 'status' => 'approved']) }}"
                                   class="btn save-btn d-block py-2 fs-9">Approved</a>
                            </div>
                        </div>
                        @endif

                        <div class="col-md-10 mb-5 text-end">
                            @php
                                $percentage = ($currentInputsNum / $totalInputs) * 100;
                            @endphp
                            <div class="progress" style="height:5px">
                                <div class="progress-bar bg-danger" role="progressbar" style="width: {{ $percentage }}%"
                                     aria-valuenow="{{ $totalInputs }}" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
                        <div class="col-md-2 mb-5 text-end">
                            <span>{{ $currentInputsNum }}/{{ $totalInputs }}</span>
                        </div>
                    </div>
                    <h3>{{ $projectForm->form->name }}</h3>
                    <p>
                        {{ $projectForm->form->desc }}
                    </p>
                    <div class="content">
                        <div class="row">
                            <h5 class="text-end">{{ $projectForm->expiration_date }}</h5>
                        </div>
                        <div class="form-content">
                            <div class="d-flex justify-content-between">
                                <div class="attached-title d-flex justify-content-center">
                                    <h5>
                                        Attached Files
                                    </h5>
                                </div>
                            </div>
                            <div class="attached-data">
                                <div class="row align-items-center">
                                    @foreach ($projectForm->form->formFiles as $file)
                                        @switch($file->type)
                                            @case('image/png')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox="gallery">
                                                        <img width="50px" height="50px" src="{{ url($file->file_path) }}"
                                                             alt="">
                                                    </a>
                                                </div>
                                                @break

                                            @case('image/jpg')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox="gallery">
                                                        <img width="50px" height="50px" src="{{ url($file->file_path) }}"
                                                             alt="">
                                                    </a>
                                                </div>
                                                @break

                                            @case('image/jpeg')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox="gallery">
                                                        <img width="50px" height="50px" src="{{ url($file->file_path) }}"
                                                             alt="">
                                                    </a>
                                                </div>
                                                @break

                                            @case('application/pdf')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox data-type="iframe">
                                                        <img src="{{ url('front_end/assets/imgs/file-icon.png') }}" alt="">
                                                    </a>
                                                </div>
                                                @break

                                            @default
                                        @endswitch
                                    @endforeach


                                </div>
                            </div>
                        </div>
                        @if(in_array($projectForm->status,['waiting approved']))
                        <form action="{{ route('branch.front.submit',$projectForm->id) }}" method="POST" id="submit-form-id"
                              enctype='multipart/form-data'>
                            @csrf
                            <input type="hidden" name="nextPage" value="{{$nextPage}}">
                            <input type="hidden" name="prevPage" value="{{$prevPage}}">
                            <input type="hidden" name="show_submit" value="{{$show_submit}}">
                        <div class="form-content">
                            <div class="form-content">
                                <div class="form-data">
                                    <div class="row">
                                        @foreach ($formInputs as $key => $input)
                                            @switch($input->input_type)
                                                @case('text')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="text-input"
                                                               class="form-label">{{ $input->formInput->label }}</label>
                                                        <input name="inputs[{{ $input->id }}][answer]" type="text"
                                                               placeholder="{{ $input->formInput->placeholder }}"
                                                               id="text-input{{ $key }}" value="{{ $input->answer != null ? $input->answer:$input->formInput->value}}"
                                                               class="form-control">
                                                        <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                               value="{{ $input->input_type }}">
                                                    </div>
                                                    @break

                                                @case('number')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="number-input"
                                                               class="form-label">{{ $input->formInput->label }}</label>
                                                        <input type="number" step="1" value="{{  $input->answer != null ? $input->answer:$input->formInput->value }}"
                                                               id="number-input{{ $key }}"
                                                               placeholder="{{ $input->formInput->placeholder }}"
                                                               class="form-control numberInput"
                                                               name="inputs[{{ $input->id }}][answer]">
                                                        <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                               value="{{ $input->input_type }}">
                                                    </div>
                                                    @break

                                                @case('textarea')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="textarea-input"
                                                               class="form-label">{{ $input->formInput->label }}</label>
                                                        <textarea class="form-control resize-none"
                                                                  name="inputs[{{ $input->id }}][answer]"
                                                                  id="textarea-input{{ $key }}" rows="3"
                                                                  placeholder="{{ $input->formInput->placeholder }}">{{ $input->answer != null ? $input->answer:$input->formInput->value}}</textarea>
                                                        <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                               value="{{ $input->input_type }}">
                                                    </div>
                                                    @break

                                                @case('file')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3 custom-file">
                                                        <label for="number-input"
                                                               class="form-label">{{ $input->formInput->label }}</label>
                                                        <input type="file" id="file-input{{ $key }}"
                                                               name="inputs[{{ $input->id }}][answer]"
                                                               class="form-control custom-file-input">
                                                        <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                               value="{{ $input->input_type }}">
                                                        <img width="60px" class="img" id="file-reader-image" src=""
                                                             alt="">
                                                        <a href="#" id="display-pdf-file"
                                                           style="display: none;text-decoration: none" data-fancybox
                                                           data-type="iframe">
                                                            <img src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                                 alt="">
                                                        </a>
                                                        @if ($input->answer)
                                                            @if ($input->file_type == 'application/pdf')
                                                                <a id="old-pdf-file" href="{{ url($input->answer) }}"
                                                                   data-fancybox data-type="iframe">
                                                                    <img
                                                                        src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                                        alt="">
                                                                </a>
                                                            @else
                                                                <a href="{{ url($input->answer) }}"
                                                                   data-fancybox="gallery">
                                                                    <img class="old-img" width="60px"
                                                                         src="{{ url($input->answer) }}" alt="">
                                                                </a>
                                                            @endif
                                                        @endif
                                                    </div>
                                                    @break
                                                @case('checkbox')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="textarea-input"
                                                               class="form-label">{{ $input->formInput->label }}</label>
                                                        @if($input->formInput->inputsElemnts != null)
                                                            @foreach($input->formInput->inputsElemnts as $el)
                                                                <div class="checkbox-group">
                                                                    <input type="checkbox" id="{{$el->name }}"
                                                                           name="inputs[{{ $input->id }}][answer][]"
                                                                           class="filled-in chk-col-danger checkbox-input"
                                                                           value="{{$el->id}}"
                                                                    @if($input->answer != null)
                                                                        {{in_array($el->id,json_decode($input->answer,true)) ?'checked':''}}
                                                                        @else
                                                                        {{ $el->name == $input->formInput->value ? 'checked':''}}
                                                                        @endif

                                                                    />
                                                                    <label for="{{$el->name}}"
                                                                           class="form-label checkbox-label">{{ $el->name }}</label>
                                                                    <input type="hidden"
                                                                           name="inputs[{{ $input->id }}][type]"
                                                                           value="{{ $input->input_type }}">

                                                                </div>

                                                            @endforeach
                                                        @endif

                                                    </div>
                                                    @break
                                                @case('radio')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="textarea-input"
                                                               class="form-label">{{ $input->formInput->label }}</label>
                                                        @if($input->formInput->inputsElemnts != null)
                                                            @foreach($input->formInput->inputsElemnts as $el)
                                                                <div class="checkbox-group">
                                                                    <input type="radio" id="{{$el->name }}"
                                                                           name="inputs[{{ $input->id }}][answer]"
                                                                           class="filled-in chk-col-danger checkbox-input"
                                                                           value="{{$el->id}}"
                                                                    @if($input->answer != null)
                                                                        {{ $el->id == $input->answer ?'checked':''}}
                                                                        @else
                                                                        {{ $el->name == $input->formInput->value ?'checked':''}}
                                                                        @endif
                                                                    />
                                                                    <label for="{{$el->name}}"
                                                                           class="form-label checkbox-label">{{ $el->name }}</label>
                                                                    <input type="hidden"
                                                                           name="inputs[{{ $input->id }}][type]"
                                                                           value="{{ $input->input_type }}">

                                                                </div>

                                                            @endforeach
                                                        @endif

                                                    </div>
                                                    @break

                                                @default
                                            @endswitch
                                        @endforeach

                                    </div>
                                </div>
                            </div>
                        </div>
                            <div class="row">
                                @if ($prevPage != 0)
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper">
                                        <button type="submit" name="submit_type" value="prev"
                                                class="btn save-btn d-block py-2 fs-5">Prev
                                        </button>
                                    </div>
                                @endif
                                @if ($show_submit == true)
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper ms-auto">
                                        <button type="submit" name="submit_type" value="submit" id="submit_button"
                                                class="btn save-btn d-block py-2 fs-5">Save
                                        </button>
                                    </div>
                                @else
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper ms-auto">
                                        <button type="submit" name="submit_type" value="next"
                                                class="btn save-btn d-block py-2 fs-5">Next
                                        </button>
                                    </div>
                                @endif

                            </div>
                        </form>
                        @else
                            <div class="form-content">
                                <div class="form-data">
                                    <div class="row">
                                        @foreach ($formInputs as $key => $input)
                                            @switch($input->input_type)
                                                @case('text')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="text-input"
                                                               class="form-label">{{ $input->formInput->label }}</label>
                                                        <input name="inputs[{{ $input->id }}][answer]" type="text"
                                                               id="text-input{{ $key }}" value="{{ $input->answer }}"
                                                               class="form-control" disabled>
                                                    </div>
                                                    @break

                                                @case('number')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="number-input"
                                                               class="form-label">{{ $input->formInput->label }}</label>
                                                        <input type="number" value="{{ $input->answer }}" disabled
                                                               id="number-input{{ $key }}" class="form-control"
                                                               name="inputs[{{ $input->id }}][answer]">
                                                    </div>
                                                    @break

                                                @case('textarea')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="textarea-input"
                                                               class="form-label">{{ $input->formInput->label }}</label>
                                                        <textarea disabled class="form-control resize-none" name="inputs[{{ $input->id }}][answer]"
                                                                  id="textarea-input{{ $key }}" rows="3">{{ $input->answer }}</textarea>
                                                        <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                               value="{{ $input->input_type }}">
                                                    </div>
                                                    @break

                                                @case('file')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3 custom-file">
                                                        <label for="number-input"
                                                               class="form-label">{{ $input->formInput->label }}</label>
                                                        @if ($input->answer !=null)
                                                            @if ($input->file_type == 'application/pdf')
                                                                <a id="old-pdf-file" href="{{ url($input->answer) }}" data-fancybox
                                                                   data-type="iframe">
                                                                    <img src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                                         alt="">
                                                                </a>
                                                            @else
                                                                <a href="{{ url($input->answer) }}" data-fancybox="gallery">
                                                                    <img class="old-img" width="60px" src="{{ url($input->answer) }}"
                                                                         alt="">
                                                                </a>
                                                            @endif
                                                        @endif
                                                    </div>
                                                    @break
                                                @case('checkbox')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="textarea-input"
                                                               class="form-label">{{ $input->formInput->label }}</label>
                                                        @if($input->formInput->inputsElemnts != null)
                                                            @foreach($input->formInput->inputsElemnts as $el)
                                                                <div class="checkbox-group">
                                                                    <input type="checkbox" id="{{$el->name }}"
                                                                           name="inputs[{{ $input->id }}][answer][]"
                                                                           class="filled-in chk-col-danger checkbox-input"
                                                                           value="{{$el->id}}"
                                                                    @if($input->answer!=null)
                                                                        {{in_array($el->id,json_decode($input->answer,true)) ?'checked':''}}
                                                                        @endif
                                                                    />
                                                                    <label for="{{$el->name}}"
                                                                           class="form-label checkbox-label">{{ $el->name }}</label>
                                                                </div>
                                                            @endforeach
                                                        @endif

                                                    </div>
                                                    @break
                                                @case('radio')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="textarea-input"
                                                               class="form-label">{{ $input->formInput->label }}</label>
                                                        @if($input->formInput->inputsElemnts != null)
                                                            @foreach($input->formInput->inputsElemnts as $el)
                                                                <div class="checkbox-group">
                                                                    <input type="radio" id="{{$el->name }}"
                                                                           name="inputs[{{ $input->id }}][answer]"
                                                                           class="filled-in chk-col-danger checkbox-input"
                                                                           value="{{$el->id}}"
                                                                    @if($input->answer!=null)
                                                                        {{$el->id == $input->answer ?'checked':''}}
                                                                        @endif
                                                                    />
                                                                    <label for="{{$el->name}}"
                                                                           class="form-label checkbox-label">{{ $el->name }}</label>

                                                                </div>

                                                            @endforeach
                                                        @endif

                                                    </div>
                                                    @break

                                                @default
                                            @endswitch
                                        @endforeach

                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                @if ($prevPage != 0)
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper">
                                        <a href="{{ route('branch.front.formView', ['id' => $projectForm->id, 'page' => $prevPage]) }}"
                                           class="btn save-btn d-block py-2 fs-5">Prev</a>
                                    </div>
                                @endif

                                @if ($nextPage != $totalPages + 1)
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper ms-auto">
                                        <a href="{{ route('branch.front.formView', ['id' => $projectForm->id, 'page' => $nextPage]) }}"
                                           class="btn save-btn d-block py-2 fs-5">Next</a>
                                    </div>
                                @else
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper ms-auto">
                                        <a href="{{ route('branch.front.index',['type' => 'general']) }}"
                                           class="btn save-btn d-block py-2 fs-5">Back</a>
                                    </div>
                                @endif
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-fancybox="gallery"]').fancybox({
                loop: true,
                keyboard: true,
                arrows: true,
                infobar: true,
                buttons: [
                    "thumbs",
                    "close",
                    "download"
                ]
            });
        })
    </script>
@endsection
