<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Petrojet Projects</title>
    <link rel="stylesheet" href="{{ url('front_end/assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ url('front_end/assets/css/style.css') }}">
    <link rel="stylesheet" href="{{ url('front_end/assets/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ url('front_end/assets/css/select2.min.css') }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Fira+Sans&display=swap" rel="stylesheet">
</head>

<body>
    <nav class="navbar">
        <div class="container-fluid">
            <div class="container">
                <a class="navbar-brand" href="#">
                    <img src="{{ url('front_end/assets/imgs/petrojet-logo.png') }}" alt=""
                        height="90px">
                </a>
            </div>
        </div>
    </nav>
    <main class="container-fluid login-container">
        <div class="container">
            <div class="row pt-5 pt-5">
                <div class="col-lg-6 col-md-8 col-sm-12 login-card m-auto">
                    <h3>Login</h3>
                    <div class="content">
                        <form method="POST" class="login-form" action="{{ route('project.login') }}">
                            @csrf
                            <div class="row">
                                <div class="select-group col-lg-6 col-md-6 col-sm-12">
                                    <div class="group-wrapper">
                                        <img src="{{ url('front_end/assets/imgs/branch-icon.png') }}" alt=""
                                            srcset="">
                                        {!! Form::select('branches[]', $branches, null, [
                                            'data-placeholder' => 'Branch',
                                            'class' => 'js-example-basic-single js-states form-control',
                                            'style' => 'width:100%',
                                            'id' => 'id_branch',
                                        ]) !!}
                                    </div>
                                </div>
                                <div class="select-group col-lg-6 col-md-6 col-sm-12" id="id_project_cont">
                                    <div class="group-wrapper">
                                        <img src="{{ url('front_end/assets/imgs/project-icon.png') }}" alt=""
                                            srcset="">
                                        {!! Form::select('project_id', $projects, null, [
                                            'class' => 'js-example-basic-single js-states form-control',
                                            'style' => 'width:100%',
                                            'id' => 'id_project',
                                            'required' => 'required',
                                            'data-placeholder' => trans('Projects'),
                                        ]) !!}
                                    </div>

                                </div>


                            </div>
                            <div class="row password-row align-items-center">
                                <div class="col-lg-12 password">
                                    <img src="{{ url('front_end/assets/imgs/password-icon.png') }}" alt=""
                                        srcset="">
                                    <input class="form-control @error('password') is-invalid @enderror" type="password"
                                        placeholder="Password" name="password" required autocomplete="current-password"
                                        id="password-input">
                                    <span class="view-password" style="cursor: pointer" id="view">
                                        <i class="fa-solid fa-eye"></i>
                                    </span>
                                    <span class="view-password d-none" style="cursor: pointer" id="un-view">
                                        <i class="fa-solid fa-eye-slash"></i>
                                    </span>

                                </div>
                            </div>
                            @if ($errors->has('message'))
                                <span role="alert">
                                    <strong> {{ $errors->first('message') }}
                                    </strong>
                                </span>
                            @endif
                            <button type="submit" class="btn login-btn d-block">Login</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <footer class="container-fluid">
        @php
            $settings = App\Models\Setting::where('id', 1)->first();
            $privacy_policy = App\Models\Page::where('id', $settings->privacy_id)
                ->select('slug')
                ->first();
            $terms_conditions = App\Models\Page::where('id', $settings->terms_id)
                ->select('slug')
                ->first();
        @endphp
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-6 col-sm-12 links">
                    <a href="{{ route('getPage', $privacy_policy->slug) }}">Privacy Policy</a>
                    <a href="{{ route('getPage', $terms_conditions->slug) }}">Terms and Conditions</a>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12 social">
                    <a href="{{ $settings->facebook }}" target="blank" class="social-link">
                        <i class="fa-brands fa-facebook-f"></i>
                    </a>
                    <a href="{{ $settings->tweetir }}" target="blank" class="social-link">
                        <i class="fa-brands fa-twitter"></i>
                    </a>
                    <a href="{{ $settings->linkedin }}" target="blank" class="social-link">
                        <i class="fa-brands fa-linkedin-in"></i>
                    </a>
                    <a href="{{ $settings->instegram }}" target="blank" class="social-link">
                        <i class="fa-brands fa-instagram"></i> </a>
                    <a href="{{ $settings->youtube }}" target="blank" class="social-link">
                        <i class="fa-brands fa-youtube"></i> </a>
                </div>
            </div>
        </div>
    </footer>
    <script src="{{ url('front_end/assets/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ url('front_end/assets/js/jquery.min.js') }}"></script>
    <script src="{{ url('front_end/assets/js/select2.min.js') }}"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#view').on('click', function(event) {
                this.classList.add('d-none')
                $('#un-view').removeClass('d-none')
                $('#password-input').attr('type', 'text')
            })

            $('#un-view').on('click', function(event) {
                this.classList.add('d-none')
                $('#view').removeClass('d-none')
                $('#password-input').attr('type', 'password')
            })
            $("#id_project").select2({
                closeOnSelect: true,
                placeholder: {
                    id: '-1', // the value of the option
                    text: 'Project'
                }
            });
            $("#id_branch").select2({
                closeOnSelect: true,
                placeholder: {
                    id: '-1', // the value of the option
                    text: 'Branch'
                }
            }).on("select2:select", function(e) {
                var branch = $(this).val();
                $.post('{{ route('frontProject.getProjectsByBranch') }}', {
                    _token: '{{ csrf_token() }}',
                    branch_id: branch
                }, function(data) {
                    $('#id_project_cont').html(data);
                });
            })
        })
    </script>
</body>

</html>
