@extends('admin.layouts.main')
@section('title'){{ $form->name }} @stop
@section('content')
    <section class="content">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="box">
                    <div class="box-header">
                        <h3 class="text-center">{{ $form->name }}</h3>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="example"
                                class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                                <thead>
                                    <tr>
                                        <th>#CODE</th>
                                        <th>Field</th>
                                        <th>Sum</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($inputs as $key => $input)
                                        <tr>
                                            <td>{{ $input->formInput->id }}</td>
                                            <td>{{ $input->formInput->label }}</td>
                                            <td>{{ $input->total }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Field</th>
                                        <th>Sum</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection


@section('script')
    <script src="{{ url('panel_them/main-semidark/js/buttons.html5.styles.min.js') }}"></script>
    <script src="{{ url('panel_them/main-semidark/js/buttons.html5.styles.templates.min.js') }}"></script>
    <script type="text/javascript">
        $('#example').DataTable({
            paging: false,
            dom: 'Bfrtip',
            template: "orange_medium", // Apply the "green_medium" template
            buttons: [{
                extend: "excel", // Extend the excel button
                excelStyles: [ // Add an excelStyles definition
                    {
                        template: "orange_medium", // Apply the "green_medium" template
                    },
                    {
                        cells: "sh", // Use Smart References (s) to target the header row (h)
                        style: { // The style definition
                            font: { // Style the font
                                size: 14, // Size 14
                                b: false, // Turn off the default bolding of the header row
                            },
                            fill: { // Style the cell fill
                                pattern: { // Add a pattern (default is solid)
                                    color: "cc0000" // Define the fill color
                                }
                            }
                        }
                    }
                ]
            }, 'print']
        });
    </script>
@endsection
