<!DOCTYPE html>
@php
    $lang = App::getlocale();
@endphp
<html @if ($lang == 'ar') lang="ar" dir="rtl" @else lang="en" dir="ltr" @endif>

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="{{ asset('showAsPaper/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('showAsPaper/styles.css') }}">
    @if ($lang == 'ar')
        <link rel="stylesheet" href="{{ asset('showAsPaper/print_ar.css') }}">
    @else
        <link rel="stylesheet" href="{{ asset('showAsPaper/print_en.css') }}">
    @endif
    <title>Petrojet</title>
</head>

<style>
    @media print {
        .content-container {
            position: relative;
            height: 100vh;
        }
        .content-container footer {
            position: absolute;
            bottom: 0;
            background-color: black !important;
        }

    }
</style>
<body>
@foreach (array_chunk($fromInput, 40) as $chunk)
    <div class="content-container">
        <header class="container py-3">
            <div class="header-content d-flex align-items-center justify-content-around ">
                <div class="header-item">
                    <p class="fw-bold text-center">
                        The Petroleum Projects & Technical <br>
                        Consultations Co. <br>
                        HSE General Department<br>

                    </p>
                </div>
                <div class="header-item">
                    <img src="{{ asset('showAsPaper/logo.png') }}" alt="">
                    <h2 class="text-center">
                        <span class='red-color'>ب</span>ترو<span class='red-color'>جـــ</span>ـت
                    </h2>
                </div>
                <div class="header-item">
                    <p class="fw-bold text-center">
                        شركة المشروعات البترولية
                        <br>
                        و الاستشارات الفنية
                        <br>
                        الإدارة العامة للسلامة و الصحة المهنية
                        <br>
                        وحماية البيئة
                    </p>
                </div>
            </div>
        </header>
        <div class="container ">
            <h2 class="title underline mb-4 text-center">
                {{$form->form->title_print}}
            </h2>

            <div class="client-info">
                <table class="table">
                    <tbody>
                    @foreach($chunk as $input)
                        @if($loop->iteration % 2 != 0)
                            <tr>
                                <th scope="col">{{ $input['form_input']['label']}}</th>
                                @if($input['input_type'] == 'checkbox')
                                    @php
                                        $answer = $input['answer'] != null ?json_decode($input['answer'], true) :[0];
                                                $checkboxName = \App\Models\fixedInputsElments::whereIn('id',$answer)->pluck('name')->toArray();
                                                $tdVal = '';
                                                if(!empty($checkboxName)){
                                                    $tdVal = '( ' . implode(' , ', $checkboxName) . ' )';
                                                }

                                    @endphp
                                    <td scope="col" colspan="2">{{ $tdVal }}</td>
                                @elseif($input['input_type'] == 'radio')
                                    @php
                                        $answer = $input['answer'] != null ?$input['answer'] :0;
                                                $checkboxName = \App\Models\fixedInputsElments::find($answer);
                                                $tdVal = '';
                                                if(!empty($checkboxName)){
                                                    $tdVal = '( ' .  $checkboxName->name . ' )';
                                                }
                                    @endphp
                                    <td scope="col" colspan="2">{{ $tdVal }}</td>
                                @elseif($input['input_type'] == 'file')
                                    @if($input['answer'] != null)
                                        <td scope="col" colspan="2"><a href="{{url($input['answer'])}}" target="blank">link</a>
                                        </td>
                                    @else
                                        <td scope="col" colspan="2"></td>
                                    @endif

                                @else
                                    <td scope="col" colspan="2">{{ $input['answer'] }}</td>
                                @endif
                                @if($loop->last)
                            </tr>
                        @endif

                        @else
                            <th scope="col">{{ $input['form_input']['label']}}</th>
                            @if($input['input_type'] == 'checkbox')
                                @php
                                    $answer = $input['answer'] != null ?json_decode($input['answer'], true) :[0];
                                            $checkboxName = \App\Models\fixedInputsElments::whereIn('id',$answer)->pluck('name')->toArray();
                                            $tdVal = '';
                                            if(!empty($checkboxName)){
                                                $tdVal = '( ' . implode(' , ', $checkboxName) . ' )';
                                            }

                                @endphp
                                <td scope="col" colspan="2">{{ $tdVal }}</td>
                            @elseif($input['input_type'] == 'radio')
                                @php
                                    $answer = $input['answer'] != null ?$input['answer'] :0;
                                            $checkboxName = \App\Models\fixedInputsElments::find($answer);
                                            $tdVal = '';
                                            if(!empty($checkboxName)){
                                                $tdVal = '( ' .  $checkboxName->name . ' )';
                                            }
                                @endphp
                                <td scope="col" colspan="2">{{ $tdVal }}</td>
                            @elseif($input['input_type'] == 'file')
                                @if($input['answer'] != null)
                                    <td scope="col" colspan="2"><a href="{{url($input['answer'])}}" target="blank">link</a></td>
                                @else
                                    <td scope="col" colspan="2"></td>
                                @endif
                            @else
                                <td scope="col" colspan="2">{{ $input['answer'] }}</td>
                                @endif
                                </tr>
                            @endif
                            @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <footer class="container py-3">
            <div class="signature d-flex align-items-center justify-content-between px-5">
                <div class="sign">
                    <p>{{ __('messages.Signatue') }} : .......................................... </p>
                </div>
                <div class="date">
                    <p>{{ __('messages.date') }} : .......................................... </p>
                </div>
            </div>
            <div class="pages-count d-flex align-items-center justify-content-between" style="background-color: #365f912d !important;">
                    <span class="pull-right">Page {{$loop->iteration}} of {{count(array_chunk($fromInput, 40))}}</span>
                <span class="pull-left">{{$form->form->footer_print}}</span>

            </div>
        </footer>
    </div>
    @if(!$loop->last)
        <p  style="page-break-before: always;"></p>
    @endif
@endforeach
<script>
    window.print();
</script>
</body>

</html>
