@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> {{ trans('messages.Show Project') }}</h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-body">
                <table class="table table-hover">
                    <thead>
                        <tr class="">
                            <th class="text-center">{{ trans('messages.Branch') }}</th>
                            <th class="text-center">{{ trans('messages.Project') }}</th>
                            <th class="text-center">{{ trans('messages.Email') }}</th>
                            <th class="text-center">{{ trans('messages.phone_project') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="text-center">{{ $project->branch->name }}</td>
                            <td class="text-center">{{ $project->name }}</td>
                            <td class="text-center">{{ $project->email }}</td>
                            <td class="text-center">{{ $project->phone }}</td>
                        </tr>
                    </tbody>
                </table>

            </div>
        </div>
        <div class="box">
            <div class="box-header">
                <h3>{{ trans('messages.Sended Forms') }}</h3>
                <form action="{{ route('project.show', $project->id) }}" method="GET">
                    <div class="row">
                        <div class="col-2">
                            <div class="app-menu">
                                <div class="search-bx mx-5">
                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                            @isset($sort_search) value="{{ $sort_search }}" @endisset
                                            placeholder="{{ trans('messages.Name') }}" aria-label="Search"
                                            aria-describedby="button-addon2">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <div>
                                    {!! Form::select('form_id', $originalForms, $form_id, [
                                        'class' => 'form-control select2',
                                        'style' => 'width:100%',
                                        'id' => 'form_id',
                                        'data-placeholder' => trans('messages.Forms'),
                                    ]) !!}
                                </div>
                            </div>

                        </div>
                        <div class="col-2">
                            <select name="status" id="status-filter" class="form-control">
                                <option value="all">{{ trans('messages.All Status') }}</option>
                                <option {{ $status == 'waiting' ? 'selected' : '' }} value="waiting">
                                    {{ trans('messages.Waiting') }}</option>
                                <option {{ $status == 'incomplete' ? 'selected' : '' }} value="incomplete">
                                    {{ trans('messages.Incomplete') }}</option>
                                <option {{ $status == 'expired' ? 'selected' : '' }} value="expired">
                                    {{ trans('messages.Expired') }}</option>
                                <option {{ $status == 'done' ? 'selected' : '' }} value="done">
                                    {{ trans('messages.Done') }}</option>
                            </select>
                        </div>
                        <div class="col-2" style="position: relative">
                            <i class="fa fa-filter"
                                style="position: absolute;{{ App::getLocale() == 'ar' ? 'right' : 'left' }}:1em;font-size: 1.5em;line-height: 1.5em;color: #FFF"></i>
                            <input style="height: 2em;line-height: 1em;padding: 0em 2em" type="submit"
                                value="{{ trans('messages.Filter') }}" class="btn btn-primary">
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-body no-padding">
                <h3 class="text-center">{{ trans('messages.Project Forms') }}</h3>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center">{{ trans('messages.Serial') }}</th>
                                <th class="text-center">{{ trans('messages.Branch') }}</th>
                                <th class="text-center">{{ trans('messages.Project') }}</th>
                                <th class="text-center">{{ trans('messages.Form Name') }}</th>
                                <th class="text-center">{{ trans('messages.Status') }}</th>
                                <th class="text-center">{{ trans('messages.Expiration') }}</th>
                                <th class="text-center">{{ trans('messages.Created') }}</th>
                                <th class="text-center">{{ trans('messages.Options') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $bills = [
                                    'waiting' => 'badge-info-light',
                                    'incomplete' => 'badge-primary-light',
                                    'expired' => 'badge-danger-light',
                                    'done' => 'badge-warning-light',
                                      'approved'=>'badge-warning-light',
                                        'rejected'=>'badge-danger-light',
                                        'waiting_approved'=>'badge-danger-light'
                                ];
                            @endphp
                            @foreach ($forms as $key => $form)
                                <tr>
                                    <td class="text-center">
                                        {{ $key + 1 }}
                                    </td>
                                    <td class="text-center">{{ $form->serial_number }}</td>
                                    <td class="text-center">{{ $form->project->branch->name }}</td>
                                    <td class="text-center">{{ $form->project->name }}</td>
                                    <td class="text-center">{{ $form->form->name }}</td>
                                    <td class="text-center">
                                        <div class="badge badge-pill {{ $bills[$form->status] }}">{{ $form->status }}
                                        </div>
                                    </td>
                                    <td class="text-center">{{ $form->expiration_date }}</td>
                                    <td class="text-center">{{ $form->created_at }}</td>
                                    <td class="text-center">
                                        <a href="{{ route('projectForm.show', $form->id) }}"
                                            class="waves-effect waves-light btn btn-primary-light btn-circle mx-5"><span
                                                class="mdi mdi-magnify"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('modal')
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            $('.select2').select2();
        })
    </script>
@endsection
