@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title">{{ trans('messages.Edit Project') }}</h3>
            </div>

        </div>
    </div>
    <!-- Main content -->

    <section class="content">
        {!! Form::open([
            'method' => 'PUT',
            'route' => ['project.update', $project->id],
            'files' => true,
            'id' => 'edit-project-form',
        ]) !!}
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="box">
                    <div class="box-body">
                        <div class="form-group">
                            <label for="name">{{ trans('messages.Branch') }}
                            </label>
                            <div>
                                {!! Form::select('branch_id', $branches, $project->branch_id, [
                                    'class' => 'form-control select2',
                                    'style' => 'width:100%',
                                    'data-placeholder' => trans('messages.Branch'),
                                ]) !!}
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="title">{{ trans('messages.Name') }}
                            </label>
                            <div>
                                {!! Form::text('name', $project->name, ['class' => 'form-control', 'placeholder' => trans('messages.Name')]) !!}
                            </div>
                            @error('name')
                                <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="title">{{ trans('messages.Hse Manager Name') }}
                            </label>
                            <div>
                                {!! Form::text('hse_manager_name', $project->hse_manager_name, [
                                    'class' => 'form-control',
                                    'placeholder' => trans('messages.Hse Manager Name'),
                                ]) !!}
                            </div>
                            @error('hse_manager_name')
                                <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="email">{{ trans('messages.Email') }}
                            </label>
                            <div>
                                {!! Form::text('email', $project->email, ['class' => 'form-control', 'placeholder' => trans('messages.Email')]) !!}
                            </div>
                            @error('email')
                                <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="email">{{ trans('messages.phone') }}
                            </label>
                            <div>
                                {!! Form::text('phone', $project->phone, ['class' => 'form-control', 'placeholder' => trans('messages.phone')]) !!}
                            </div>
                            @error('phone')
                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                            </div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="name">{{ trans('messages.Forms') }}
                            </label>
                            <div>
                                {!! Form::select('forms[]', $periodicForms, $project->forms, [
                                    'class' => 'form-control select2',
                                    'style' => 'width:100%',
                                    'id' => 'forms_ids',
                                    'multiple' => 'multiple',
                                    'data-placeholder' => trans('messages.Forms'),
                                ]) !!}
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <button type="submit" class="btn btn-rounded btn-primary btn-outline">
                            <i class="ti-save-alt"></i> {{ trans('messages.Save') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
        {!! Form::Close() !!}
    </section>
@endsection


@section('script')
    <script type="text/javascript">
        $('.select2').select2();
    </script>
@endsection
