@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title">{{ trans('messages.Add New notificationbar') }}</h3>
            </div>

        </div>
    </div>


    <!-- Main content -->

    <section class="content">
       <form method="post" action="{{route('notificationbar.updatedSave',$bar->id)}}">
        <input type="hidden" name="_token" value="{{csrf_token()}}">

        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="box">
                    <div class="box-body">
                        <div class="form-group">
                            <label for="title">{{ trans('messages.text') }}
                            </label>
                            <div>
                                <textarea name="text" class="form-control" placeholder="{{trans('messages.text')}}"
                                          required>
                                    {{old('text')!=null?old('text') : $bar->text}}
                                </textarea>
                            </div>
                            @error('text')
                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                            </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="active">{{ trans('messages.Status') }}
                            </label>
                            <select class="form-control select2" name="active" id="active" required>
                                <option value="1"
                                @if(old('active') != null)
                                    {{old('active') == 1 ?'selected':''}}
                                    @else
                                    {{$bar->active == 1?'selected':'' }}
                                    @endif
                                >{{ trans('messages.actvie') }}</option>
                                <option
                                    value="0"

                                @if(old('active') != null)
                                    {{old('active') == 0 ?'selected':''}}
                                    @else
                                    {{$bar->active == 0?'selected':'' }}
                                    @endif

                                >{{ trans('messages.unactive') }}</option>
                            </select>
                            @error('active')
                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                            </div>
                            @enderror
                        </div>


                    </div>

                    <div class="box-footer">
                        <button type="submit" class="btn btn-rounded btn-primary btn-outline">
                            <i class="ti-save-alt"></i> {{ trans('messages.Save') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
       </form>
    </section>
@endsection
