@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> {{ trans('messages.Forms') }}</h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-4">
                        <div class="app-menu">
                            <div class="search-bx mx-5">
                                <form action="{{ route('notificationbar.index') }}" method="GET">
                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                               @isset($sort_search) value="{{ $sort_search }}" @endisset
                                               placeholder="{{ trans('messages.Name') }}" aria-label="Search"
                                               aria-describedby="button-addon2">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col" style="text-align: end">
                        <a href="{{ route('notificationbar.create') }}"
                           class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                class="mdi mdi-plus"><span class="path1"></span><span class="path2"></span></span></a>

                    </div>
                </div>

            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                        <tr class="">
                            <th class="text-center">
                                #
                            </th>
                            <th class="text-center">{{ trans('messages.Name') }}</th>
                            <th class="text-center">{{ trans('messages.Status') }}</th>
                            <th class="text-center">{{ trans('messages.Options') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($notifications as $key => $form)
                            <tr>
                                <td class="text-center">
                                    {{ $key + 1 + ($notifications->currentPage() - 1) * $notifications->perPage() }}
                                </td>
                                <td class="text-center">{{ $form->text }}</td>
                                <td class="text-center">{{ $form->active == 1 ?trans('messages.actvie') :trans('messages.unactive')  }}</td>
                                <td class="text-center">
                                    <form action="{{ route('notificationbar.del', $form->id) }}" method="Post"
                                          id="destroy-form-{{ $form->id }}">
                                        @csrf
                                        @method('DELETE')
                                    </form>
                                    <a href="{{ route('notificationbar.updated', $form->id) }}"
                                       class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                            class="icon-Write"><span class="path1"></span><span
                                                class="path2"></span></span></a>

                                    <a data-title="{{ trans('messages.Are you sure?') }}"
                                       data-no="{{ trans('messages.Cancel') }}"
                                       data-yes="{{ trans('messages.Yes, delete it!') }}"
                                       data-desc="{{ trans('messages.You will not be able to recover this!') }}"
                                       href="#" data-href="{{ $form->id }}"
                                       class="sa-warning waves-effect waves-light btn btn-primary-light btn-circle"><span
                                            class="icon-Trash1"><span class="path1"></span><span
                                                class="path2"></span></span></a>
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                    {!! $notifications->withQueryString()->links('pagination::bootstrap-4') !!}

                </div>
            </div>
        </div>
    </section>
@endsection
@section('modal')
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript"></script>
@endsection
