@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title">{{ trans('messages.Add New notificationbar') }}</h3>
            </div>

        </div>
    </div>


    <!-- Main content -->

    <section class="content">
        {!! Form::open(['route' => 'notificationbar.store', 'id' => 'add-user-form']) !!}
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="box">
                    <div class="box-body">
                        <div class="form-group">
                            <label for="text">{{ trans('messages.text') }}
                            </label>
                            <div>
                                <textarea name="text" class="form-control" placeholder="{{trans('messages.text')}}" required>
                                    {{old('text')}}
                                </textarea>
                            </div>
                            @error('text')
                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                            </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="active">{{ trans('messages.Status') }}
                            </label>
                           <select class="form-control select2" name="active" id="active" required>
                               <option value="1" {{old('active') == 1 ?'selected':''}}>{{ trans('messages.actvie') }}</option>
                               <option value="0" {{old('active') == 0 ?'selected':''}}>{{ trans('messages.unactive') }}</option>
                           </select>
                            @error('active')
                            <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                            </div>
                            @enderror
                        </div>


                    </div>

                    <div class="box-footer">
                        <button type="submit" class="btn btn-rounded btn-primary btn-outline">
                            <i class="ti-save-alt"></i> {{ trans('messages.Save') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
        {!! Form::Close() !!}
    </section>
@endsection
