@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> {{ trans('messages.Show Form') }}</h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-body no-padding">
                <div class="box box-inverse box-secondary">
                    <div class="box-header ">
                        <h3 class="box-title"><strong>{{ $form->name }}</strong></h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12 data-group">
                                <span> <strong>Desc:</strong></span>
                                <span>{{ $form->desc }}</span>
                            </div>
                            <div class="col-md-3 data-group">
                                <span> <strong>title in print:</strong></span>
                                <span>{{ $form->title_print }}</span>
                            </div>
                            <div class="col-md-3 data-group">
                                <span> <strong>footer in print:</strong></span>
                                <span>{{ $form->footer_print }}</span>
                            </div>
                        </div>
                    </div>

                </div>


                <style>
                    #gallery-content-center img {
                        width: 100px
                    }

                    .form-label {
                        padding-block: 10px;
                        border-bottom: 1px solid rgba(72, 94, 144, 0.16);
                        border-inline: 1px solid rgba(72, 94, 144, 0.16);
                        /*box-shadow: 1px 0px 1px rgba(173, 173, 173, 0.932);*/
                    }
                </style>
                <div class="box bl-3 border-primary">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md">
                                <div class="box-header">
                                    <h3 class="text-center">Form Data</h3>
                                </div>
                                <div class="attached-data">
                                    <div id="gallery-content">
                                        <div id="gallery-content-center">
                                            <div class="row">
                                                @foreach ($form->formFiles as $file)
                                                    @switch($file->type)
                                                        @case('image/png')
                                                            <a href="{{ url($file->file_path) }}" data-toggle="lightbox"
                                                               data-gallery="multiimages"
                                                               data-title="Show Form Files"><img
                                                                    src="{{ url($file->file_path) }}" alt="gallery"
                                                                    class="all studio col-md-4"/> </a>
                                                            @break

                                                        @case('image/jpg')
                                                            <a href="{{ url($file->file_path) }}" data-toggle="lightbox"
                                                               data-gallery="multiimages"
                                                               data-title="Show Form Files"><img
                                                                    src="{{ url($file->file_path) }}" alt="gallery"
                                                                    class="all studio col-md-4"/> </a>
                                                            @break

                                                        @case('image/jpeg')
                                                            <a href="{{ url($file->file_path) }}" data-toggle="lightbox"
                                                               data-gallery="multiimages"
                                                               data-title="Show Form Files"><img
                                                                    src="{{ url($file->file_path) }}" alt="gallery"
                                                                    class="all studio col-md-4"/> </a>
                                                            @break

                                                        @case('application/pdf')
                                                            <a href="{{ url($file->file_path) }}" data-fancybox
                                                               data-type="iframe">
                                                                <img
                                                                    src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                                    alt="">
                                                            </a>
                                                            @break

                                                        @default
                                                    @endswitch
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @php
                                    $bills = [
                                        'text' => 'badge-info-light',
                                        'number' => 'badge-primary-light',
                                        'textarea' => 'badge-danger-light',
                                        'file' => 'badge-warning-light',
                                         'checkbox' => 'badge-secondary-light',
                                         'radio' => 'badge-dark'
                                    ];
                                @endphp
                                @foreach ($form->formInputs as $key => $input)
                                    <div for="text-input" class="form-label px-3 d-flex justify-content-between ">
                                        <span class="input-label d-block">
                                            {{ $input->label }}
                                        </span>
                                        <div class="field-padges">
                                            <span
                                                class="badge badge-pill {{ $bills[$input->input_type] ?? '' }}">{{ $input->input_type }}</span>
                                            @if($input->value != null)
                                                <span
                                                    class="badge badge-pill {{ $bills[$input->input_type] ?? '' }}">{{ $input->value }}</span>
                                            @endif
                                            @if($input->placeholder != null)
                                                <span
                                                    class="badge badge-pill {{ $bills[$input->input_type] ?? '' }}">{{ $input->placeholder }}</span>
                                            @endif
                                            @if(in_array($input->input_type,['checkbox','radio']))
                                                @foreach($input->inputsElemnts as $el)
                                                    <span
                                                        class="badge badge-pill {{$input->value == $el->name ? $bills[$input->input_type] :'badge-primary-light' }}">{{ $el->name }}</span>
                                                @endforeach
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>
@endsection
@section('modal')
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        // delegate calls to data-toggle="lightbox"
        $(document).delegate('*[data-toggle="lightbox"]:not([data-gallery="navigateTo"])', 'click', function (event) {
            event.preventDefault();
            return $(this).ekkoLightbox({
                onShown: function () {
                    if (window.console) {
                        return console.log('Checking our the events huh?');
                    }
                },
                onNavigate: function (direction, itemIndex) {
                    if (window.console) {
                        return console.log('Navigating ' + direction + '. Current item: ' + itemIndex);
                    }
                }
            });
        });
        //Programatically call
        $('#open-image').click(function (e) {
            e.preventDefault();
            $(this).ekkoLightbox();
        });
        $('#open-youtube').click(function (e) {
            e.preventDefault();
            $(this).ekkoLightbox();
        });
        // navigateTo
        $(document).delegate('*[data-gallery="navigateTo"]', 'click', function (event) {
            event.preventDefault();
            var lb;
            return $(this).ekkoLightbox({
                onShown: function () {
                    lb = this;
                    $(lb.modal_content).on('click', '.modal-footer a', function (e) {
                        e.preventDefault();
                        lb.navigateTo(2);
                    });
                }
            });
        });
    </script>
@endsection
