@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title">{{ trans('messages.Add New Form') }}</h3>
            </div>

        </div>
    </div>

    <style>
        .bootstrap-tagsinput {
            width: 100%;
            padding: 0.6em;
        }

        .box {
            border-top: 20px solid #C4161C;
            border-radius: 20px;
            border-bottom: 20px solid #C4161C !important;
            box-shadow: none !important;
        }

        .box-header {
            border-bottom: 13px solid #f8f8fb;
        }

        .input-group .input-group-text {

            border-color: #C4161C
        }

        .form-name input {
            border-left: none;
        }

        .btn-filled {
            background-color: #000000 !important;
            border: none
        }

        .add-new-field {
            border-right: 2px solid #000000;
        }

        .add-new-field i {
            cursor: pointer;
            font-size: 1.5em;
            position: absolute;
            bottom: 15px;
            right: 5px;
        }

        .theme-primary [type=radio]:checked + label:after {
            border: 2px solid #C4161C;
            background-color: #C4161C;
        }

        .progress {
            position: relative;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: white;
            overflow: hidden;
            background-image: conic-gradient(red 0%, rgba(255, 136, 136, 0.644) 0);
        }

        .progress .inner {
            display: flex;
            justify-content: center;
            align-items: center;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 34px;
            height: 34px;
            background: white;
            border-radius: 50%;
            font-size: 1em;
            font-weight: 400;
        }

        .extinsions {
            color: #C4161C;
            font-size: 1.2em;
        }
    </style>
    <!-- Main content -->

    <section class="content">
        <div class="row">
            <div class="col-lg-8">

                <div class="box">
                    {!! Form::open(['route' => 'form.store', 'files' => true, 'id' => 'add-form-form']) !!}
                    <div class="box-header">
                        <div class="row">
                            <div class="col-6 mx-auto">
                                <div class="form-group">
                                    <div class="input-group mb-3 form-name">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i style="font-size: 1.5em;"
                                                                              class="fa fa-fw fa-file"></i></span>
                                        </div>
                                        {!! Form::text('name', null, [
                                            'class' => 'form-control text-center',
                                            'placeholder' => trans('messages.Form Name'),
                                            'required' => 'required',
                                        ]) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="col-6 d-flex justify-content-end">
                                <input type="checkbox" id="approval" name="approval"
                                       class="form-control filled-in"/>
                                <label for="approval">approval</label>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <div class="input-group mb-3">
                                        {!! Form::textarea('desc', null, [
                                            'class' => 'form-control',
                                            'placeholder' => trans('messages.desc'),
                                            'required' => 'required',
                                        ]) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    <div class="input-group mb-3 form-name">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i style="font-size: 1.5em;" class="fa fa-fw fa-header"></i></span>
                                        </div>
                                        {!! Form::text('title_print', null, [
                                            'class' => 'form-control',
                                            'placeholder' => trans('messages.title_print'),

                                        ]) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    <div class="input-group mb-3 form-name">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i style="font-size: 1.5em;"
                                                                              class="fa fa-fw fa-tasks"></i></span>
                                        </div>
                                        {!! Form::text('footer_print', null, [
                                            'class' => 'form-control',
                                            'placeholder' => trans('messages.footer_print'),

                                        ]) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="box-body">
                        <h3 class="text-center">{{ trans('messages.Import Exel file') }}
                            {{-- <input type="file" id="importFieldsFile" class="fa fa-fw fa-file-excel-o" style="width: 0.85614em;cursor: pointer;"> --}}
                            <i class="fa fa-fw fa-file-excel-o" style="cursor: pointer" id="show-input"></i>
                            <input type="file" id="importFieldsFile" style="display:none">
                        </h3>
                        <h5 class="text-center">
                            Example
                            <i class="fa fa-arrow fa-arrow-right"></i>
                            <a href="{{ url('importFormExample.xlsx') }}" target="blank">
                                <img src="{{ url('excelImage.png') }}" width="25px" alt="">
                            </a>
                        </h5>
                        <br>
                        <div class="row">
                            <div class="col-1 add-new-field" style="position: relative;">
                                <i id="add-new-field-i" title="{{ trans('messages.Add new field') }}"
                                   class="fa fa-plus"></i>
                            </div>
                            <div class="col-11" id="form-fields-container">

                            </div>
                        </div>
                        <hr>
                        <h5 class="text-center">{{ trans('messages.Form Delevery Type') }}</h5>
                        <div class="row text-center">
                            <div class="col">
                                <input name="periodic_onetime" type="radio" id="radio_2" value="onetime" checked/>
                                <label for="radio_2">{{ trans('messages.One Time') }}</label>
                            </div>
                            <div class="col">
                                <input name="periodic_onetime" type="radio" id="radio_1" value="periodic"/>
                                <label for="radio_1">{{ trans('messages.Periodic') }}</label>
                            </div>

                        </div>
                        <hr>
                        <div class="one-time-options">
                            <h5 class="text-center">{{ trans('messages.One time Type') }}</h5>
                            <div class="row text-center">
                                <div class="col">
                                    <input name="one_time_type" type="radio" id="radio_6" value="today" checked/>
                                    <label for="radio_6">{{ trans('messages.Today') }}</label>
                                </div>
                                <div class="col">
                                    <input name="one_time_type" type="radio" id="radio_7" value="spacific"/>
                                    <label for="radio_7">{{ trans('messages.Spacific time') }}</label>
                                </div>
                            </div>
                            <div class="form-group text-center" id="one_type_send_time" style="display: none">
                                <label for="month_day">{{ trans('messages.Send At') }}</label>
                                <input type="date" name="one_type_send_time" id="" class="form-control">
                            </div>
                        </div>
                        <div class="periodic-opthions" style="display: none">
                            <h5 class="text-center">{{ trans('messages.Periodic Type') }}</h5>
                            <div class="row text-center">
                                <div class="col">
                                    <input name="periodic_type" type="radio" id="radio_3" value="week" checked/>
                                    <label for="radio_3">{{ trans('messages.Every Week') }}</label>
                                </div>
                                <div class="col">
                                    <input name="periodic_type" type="radio" id="radio_4" value="month"/>
                                    <label for="radio_4">{{ trans('messages.Every Month') }}</label>
                                </div>
                                <div class="col">
                                    <input name="periodic_type" type="radio" id="radio_5" value="quarter"/>
                                    <label for="radio_5">{{ trans('messages.Every Quarter') }}</label>
                                </div>
                            </div>
                            <hr>
                            <div class="row text-center">
                                <div class="col-4 mx-auto select-periodic-type-container">
                                    <div class="form-group">
                                        <label for="week_day">{{ trans('messages.Choose Week Day') }}</label>
                                        <select name="week_day" id="week_day" class="form-control">
                                            <option value="1">{{ trans('messages.Monday') }}</option>
                                            <option value="2">{{ trans('messages.Tuesday') }}</option>
                                            <option value="3">{{ trans('messages.Wednesday') }}</option>
                                            <option value="4">{{ trans('messages.Thursday') }}</option>
                                            <option value="5">{{ trans('messages.Friday') }}</option>
                                            <option value="6">{{ trans('messages.Saturday') }}</option>
                                            <option value="7">{{ trans('messages.Sunday') }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md">
                                <div class="form-group">
                                    <label for="dead_line_by_num_of_dayes">{{ trans('messages.Form Files') }}</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input-form" id="customFile">
                                        <label class="custom-file-label" for="customFile">Choose file</label>
                                    </div>
                                    <span class="extinsions">{{ trans('File type : ') }} jpg | jpeg | png | pdf</span>
                                </div>
                            </div>
                            <div class="col-md-1" style="display: none" id="file-upload-progress-container">
                                <label></label>
                                <div class="wrap-progress">
                                    <div class="progress" id="file-upload-progress">
                                        <div class="inner">0%</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="dead_line_by_num_of_dayes">{{ trans('messages.Deadline') }}</label>
                                    <input class="form-control" type="number" value="1"
                                           oninput="this.value=this.value.slice(0,3);" min="0" max="999"
                                           name="dead_line_by_num_of_dayes" id="dead_line_by_num_of_dayes">
                                </div>
                            </div>
                        </div>


                        <br>
                        <br>
                        <div class="form-group">
                            <button type="submit"
                                    class="btn btn-rounded btn-primary btn-filled form-control">{{ trans('messages.Next') }}
                            </button>
                        </div>


                    </div>
                    {!! Form::Close() !!}
                </div>

                <!-- /.box-body -->

            </div>
            <div class="col-md">
                <div class="box">
                    <div class="box-header">
                        <h4 class="text-center" style="padding-bottom: 1em">{{ trans('messages.Form Files') }}</h4>
                    </div>
                    <div class="box-body">
                        <div class="uploaded-files-container">

                        </div>
                        <table>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
    </section>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            $.get(`{{ route('formFile.index') }}`, {
                    temp_serial: `{{ session('temp_serial') }}`
                },
                function (data2) {
                    $('.uploaded-files-container').html(data2);

                });

            var inputCounter = 0;
            $('.select2').select2();
            $.get(`{{ route('form.addField') }}`, {
                    inputCounter: inputCounter
                },
                function (data) {
                    $('#form-fields-container').append(data);
                });
            $('#add-new-field-i').click(function () {
                inputCounter++;
                $.get(`{{ route('form.addField') }}`, {
                        inputCounter: inputCounter
                    },
                    function (data) {
                        $('#form-fields-container').append(data);

                    });
            })

            $('input[name=periodic_onetime]').change(function () {
                var selectedValue = $('input[name=periodic_onetime]:checked').val();
                if (selectedValue == 'onetime') {
                    $('.periodic-opthions').hide();
                    $('.one-time-options').show();
                } else {
                    $('.periodic-opthions').show();
                    $('.one-time-options').hide();
                }
            });
            $('input[name=periodic_type]').change(function () {
                var selectedValue = $('input[name=periodic_type]:checked').val();
                $.get(`{{ route('form.getPeriodicTypeSelect') }}`, {
                        selectedValue: selectedValue
                    },
                    function (data) {
                        $('.select-periodic-type-container').html(data);

                    });
            });
            $('input[name=one_time_type]').change(function () {
                var selectedValue = $('input[name=one_time_type]:checked').val();
                if (selectedValue == 'spacific') {
                    $('#one_type_send_time').show();
                } else {
                    $('#one_type_send_time').hide();
                }
            });

            $('#show-input').click(function () {
                $('#importFieldsFile').click()
            })
            document.querySelector('input[id="customFile"]').addEventListener('change', function () {
                var fileInput = document.querySelector('input[id="customFile"]');
                var file = fileInput.files[0];
                var fileExtension = file.name.split('.').pop().toLowerCase();

                // Check file extension
                if (fileExtension !== 'jpg' && fileExtension !== 'jpeg' && fileExtension !== 'png' &&
                    fileExtension !== 'pdf') {
                    alert('Only PDF, JPG, JPEG, and PNG files are allowed.');
                    fileInput.value = ''; // Clear the file input
                    return;
                }
                $('#file-upload-progress-container').slideToggle();
                var formData = new FormData();
                formData.append('file', document.querySelector('input[id="customFile"]').files[0]);
                formData.append('temp_serial', `{{ session('temp_serial') }}`);
                formData.append('_token', '{{ csrf_token() }}');
                var xhr = new XMLHttpRequest();
                xhr.open('POST', `{{ route('formFile.store') }}`);
                xhr.upload.addEventListener("progress", function (event) {

                    if (event.lengthComputable) {
                        var percentComplete = Math.round((event.loaded / event.total) * 100);
                        $('#file-upload-progress').css('background-image', 'conic-gradient(red ' +
                            percentComplete + '%, rgba(255, 136, 136, 0.644) 0)')
                        $('.progress .inner').text(percentComplete + '%');
                        if (percentComplete == 100) {
                            setTimeout(() => {
                                $('#file-upload-progress-container').hide();
                                $('#file-upload-progress').css('background-image',
                                    'conic-gradient(red ' +
                                    0 + '%, rgba(255, 136, 136, 0.644) 0)'
                                )
                                $('.progress .inner').text(0 + '%');
                            }, 500);
                        }
                    }
                }, false);

                xhr.onreadystatechange = function () {
                    console.log(xhr);
                    if (xhr.status == 200) {
                        var data = JSON.parse(xhr.responseText);
                        if (data.success == true) {
                            $.get(`{{ route('formFile.index') }}`, {
                                    temp_serial: `{{ session('temp_serial') }}`
                                },
                                function (data2) {
                                    $('.uploaded-files-container').html(data2);
                                });
                        } else {
                            console.log(data)
                        }
                    } else {
                        console.log('Error: ' + xhr.status);
                    }
                }

                xhr.send(formData);
            });
            $('#importFieldsFile').change(function () {
                var file_data = $('#importFieldsFile').prop('files')[0];
                var form_data = new FormData();
                form_data.append('inputCounter', inputCounter);
                form_data.append('file', file_data);
                form_data.append('_token', '{{ csrf_token() }}');

                $.ajax({
                    url: '{{ route('form.uploadFieldsFile') }}',
                    dataType: 'text',
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: form_data,
                    type: 'post',
                    success: function (response) {
                        $('#form-fields-container').append(response);
                    },
                    error: function (xhr, status, error) {
                        console.log(error);
                    }
                });
                form_data.append('getCounterUpdate', 1);
                $.ajax({
                    url: '{{ route('form.uploadFieldsFile') }}',
                    dataType: 'text',
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: form_data,
                    type: 'post',
                    success: function (response) {
                        inputCounter = response - 1;
                        // console.log(response);
                        // console.log(inputCounter);
                    },
                    error: function (xhr, status, error) {
                        console.log(error);
                    }
                });
            });

        })

        function addNewCheckBox(id) {
            $('#myCheckInputHere_' + id).append(
                `<div class="col-md-6 mb-3">
                        <div class="row">
                            <div class="col-md-10">
                                <input class="form-control text-center" type="text" placeholder="add your content"
                                       name="inputs[` + id + `][checkbox][]">
                            </div>
                            <div class="col-md-2">
                                <i class="fa fa-trash toRemoveSelected" style="cursor: pointer;font-size: 1.5em"
                                ></i>
                            </div>
                        </div>

                    </div>`
            );
            removeSelected();
        }

        function addRadio(id) {
            $('#myRadioInputHere_' + id).append(
                `<div class="col-md-6 mb-3">
                        <div class="row">
                            <div class="col-md-10">
                                <input class="form-control text-center" type="text" placeholder="add your content"
                                       name="inputs[` + id + `][radio][]">
                            </div>
                            <div class="col-md-2">
                                <i class="fa fa-trash toRemoveSelected" style="cursor: pointer;font-size: 1.5em"
                                ></i>
                            </div>
                        </div>

                    </div>`
            );
            removeSelected();
        }

        function deleteoneFieldContainer(counter) {
            $('#oneFieldContainer_' + counter).remove();
        }


        function removeSelected() {
            let pinselected = Array.from(document.querySelectorAll('.toRemoveSelected'));
            let count = pinselected.length;
            for (let i = 0; i < count; i++) {
                pinselected[i].addEventListener('click', function (e) {
                    let parentElement = pinselected[i].closest('.col-md-6');
                    if (parentElement) {
                        parentElement.remove();
                    }
                });
            }

        }


    </script>
@endsection
