@extends('admin.layouts.main')
@section('content')
    <div class="container-full">
        <section class="content">
            <div class="no-padding">
                <div class="row">
                    <div class="col-md-3 col-sm-12">
                        <div class="box pull-up">
                            <div class="box-body">
                                <div class="text-center">
                                    <h1 class="font-size-40 text-primary"><i class="fa fa-sitemap"></i></h1>
                                    <h2>{{ $branchesCount }}</h2>
                                    <span class="badge badge-pill badge-primary px-10 mb-10">Branches</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-12">
                        <div class="box pull-up">
                            <div class="box-body">
                                <div class="text-center">
                                    <h1 class="font-size-40 text-warning"><i class="mdi mdi-file-document"></i></h1>
                                    <h2>{{ $projectsCount }}</h2>
                                    <span class="badge badge-pill badge-warning px-10 mb-10">Projects</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-12">
                        <div class="box pull-up">
                            <div class="box-body">
                                <div class="text-center">
                                    <h1 class="font-size-40 text-info"><i class="mdi mdi-calendar-multiple"></i></h1>
                                    <h2>{{ $formsCount }}</h2>
                                    <span class="badge badge-pill badge-info px-10 mb-10">Forms</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-12">
                        <div class="box pull-up">
                            <div class="box-body">
                                <div class="text-center">
                                    <h1 class="font-size-40 text-success"><i class="mdi mdi-calendar-multiple-check"></i>
                                    </h1>
                                    <h2>{{ $SendedFormsCount }}</h2>
                                    <span class="badge badge-pill badge-success px-10 mb-10">Sent Forms</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col">
                    <div class="box" style="height: 15em;overflow-y: auto;">
                        <div class="box-body text-center">
                            <div class="mb-20 mt-20">
                                <h4 class="mt-20 mb-0">{{ trans('messages.Forms To Be Expired') }}</h4>
                            </div>
                            @php
                                $bills = ['badge-info-light', 'badge-primary-light', 'badge-danger-light', 'badge-warning-light'];
                            @endphp
                            @forelse ($Expirforms as $Expirform)
                                <div class="badge badge-pill {{ $bills[rand(1, 3)] }} font-size-16" style="margin: 4px;">
                                    {{ $Expirform->project->name }} - {{ $Expirform->form->name }}
                                </div>
                            @empty
                                <div class="badge badge-pill badge-info-light font-size-16">
                                    {{ trans('messages.No Forms to be expired.') }}
                                </div>
                            @endforelse
                        </div>
                        <div class="p-20 mt-15 bt-1">
                            <div class="row text-center">
                                <div class="col">
                                    <a href="#" onclick="makeFormsExpired()"
                                        class="link d-flex align-items-center justify-content-center font-medium">
                                        {{ trans('messages.Make Expired') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="box" style="height: 15em;overflow-y: auto;">
                        <div class="box-body text-center">
                            <div class="mb-20 mt-20">
                                <h4 class="mt-20 mb-0">{{ trans('messages.Forms To Be Send') }}</h4>
                            </div>
                            @php
                                $bills = ['badge-info-light', 'badge-primary-light', 'badge-danger-light', 'badge-warning-light'];
                            @endphp
                            @forelse ($publishForms as $pForm)
                                <div class="badge badge-pill {{ $bills[rand(1, 3)] }} font-size-16" style="margin: 4px;">
                                    {{ $pForm->name }}
                                </div>
                            @empty
                                <div class="badge badge-pill badge-info-light font-size-16">
                                    {{ trans('messages.No Forms to be send.') }}
                                </div>
                            @endforelse
                        </div>
                        <div class="p-20 mt-15 bt-1">
                            <div class="row text-center">
                                <div class="col">
                                    <a href="#" onclick="publishForms()"
                                        class="link d-flex align-items-center justify-content-center font-medium">
                                        {{ trans('messages.Send now') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="box">
                <div class="box-header">
                    <h3>{{ trans('messages.Latest Sended Forms') }}</h3>
                </div>
                <div class="box-body no-padding">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr class="">
                                    <th class="text-center">
                                        #
                                    </th>
                                    <th class="text-center">{{ trans('messages.Serial') }}</th>
                                    <th class="text-center">{{ trans('messages.Branch') }}</th>
                                    <th class="text-center">{{ trans('messages.Project') }}</th>
                                    <th class="text-center">{{ trans('messages.Form Name') }}</th>
                                    <th class="text-center">{{ trans('messages.Status') }}</th>
                                    <th class="text-center">{{ trans('messages.Expiration') }}</th>
                                    <th class="text-center">{{ trans('messages.Created') }}</th>
                                    <th class="text-center">{{ trans('messages.Options') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $bills = [
                                        'waiting' => 'badge-info-light',
                                        'incomplete' => 'badge-primary-light',
                                        'expired' => 'badge-danger-light',
                                        'done' => 'badge-warning-light',
                                          'approved'=>'badge-warning-light',
                                'rejected'=>'badge-danger-light',
                                        'waiting approved' => 'badge-info-light',
                                    ];
                                @endphp
                                @foreach ($forms as $key => $form)
                                    <tr>
                                        <td class="text-center">
                                            {{ $key + 1 }}
                                        </td>
                                        <td class="text-center">{{ $form->serial_number }}</td>
                                        <td class="text-center">{{ $form->project->branch->name }}</td>
                                        <td class="text-center">{{ $form->project->name }}</td>
                                        <td class="text-center">{{ $form->form->name }}</td>
                                        <td class="text-center">
                                            <div class="badge badge-pill {{ $bills[$form->status] }}">{{ $form->status }}
                                            </div>
                                        </td>
                                        <td class="text-center">{{ $form->expiration_date }}</td>
                                        <td class="text-center">{{ $form->created_at }}</td>
                                        <td class="text-center">
                                            <a href="{{ route('projectForm.show', $form->id) }}"
                                                class="waves-effect waves-light btn btn-primary-light btn-circle mx-5"><span
                                                    class="mdi mdi-magnify"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>

            </div>

        </section>
    </div>
@endsection
@section('modal')
@endsection

@section('script')
    <script type="text/javascript">
        function makeFormsExpired() {
            $.get(`{{ route('projectForm.updateExpiration') }}`, {},
                function(data) {
                    window.location.reload();
                });
        }

        function publishForms() {
            $.get(`{{ route('projectForm.publishForms') }}`, {},
                function(data) {
                    window.location.reload();
                });
        }
    </script>
@endsection
