@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> {{ trans('messages.Branches') }}</h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-4">
                        <div class="app-menu">
                            <div class="search-bx mx-5">
                                <form action="{{ route('branch.index') }}" method="GET">
                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                            @isset($sort_search) value="{{ $sort_search }}" @endisset
                                            placeholder="{{ trans('messages.Name') }}" aria-label="Search"
                                            aria-describedby="button-addon2">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col" style="text-align: end">
                        <div class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                class="fa fa-fw fa-file-excel-o" id="show-input"><span class="path1"></span><span
                                    class="path2"></span></span></div>
                        <input type="file" id="importFieldsFile" style="display:none">

                        <a href="{{ url('importBranchExample.xlsx') }}" target="blank"
                            class="waves-effect waves-light btn btn-primary-light btn-circle"><span>
                                <img src="{{ url('excelImage.png') }}" style="width: 30px;" alt="">
                                <span class="path1"></span><span class="path2"></span></span></a>

                        <a href="{{ route('branch.create') }}"
                            class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                class="mdi mdi-plus"><span class="path1"></span><span class="path2"></span></span></a>

                    </div>
                </div>

            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center">{{ trans('messages.Name') }}</th>
                                <th class="text-center">{{ trans('messages.user_name') }}</th>
                                <th class="text-center">{{ trans('messages.Email') }}</th>
                                <th class="text-center">{{ trans('messages.phone') }}</th>
                                <th class="text-center">{{ trans('messages.Created') }}</th>
                                <th class="text-center">{{ trans('messages.Options') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($branches as $key => $branch)
                                <tr>
                                    <td class="text-center">
                                        {{ $key + 1 + ($branches->currentPage() - 1) * $branches->perPage() }}
                                    </td>
                                    <td class="text-center">{{ $branch->name }}</td>
                                    <td class="text-center">{{ $branch->user_name }}</td>
                                    <td class="text-center">{{ $branch->email }}</td>
                                    <td class="text-center">{{ $branch->phone }}</td>
                                    <td class="text-center">{{ $branch->created_at }}</td>
                                    <td class="text-center">
                                        <form action="{{ route('branch.destroy', $branch->id) }}" method="Post"
                                            id="destroy-form-{{ $branch->id }}">
                                            @csrf
                                            @method('DELETE')
                                        </form>
                                        <a href="{{ route('branch.show', $branch->id) }}"
                                            class="waves-effect waves-light btn btn-primary-light btn-circle mx-5"><span
                                                class="mdi mdi-magnify"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                        <a href="{{ route('branch.edit', $branch->id) }}"
                                            class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                class="icon-Write"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                        <a href="{{ route('branch.viewpassword', $branch->id) }}"
                                           class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                class="icon-Lock"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                        <a data-title="{{ trans('messages.Are you sure?') }}"
                                            data-no="{{ trans('messages.Cancel') }}"
                                            data-yes="{{ trans('messages.Yes, delete it!') }}"
                                            data-desc="{{ trans('messages.You will not be able to recover this!') }}"
                                            href="#" data-href="{{ $branch->id }}"
                                            class="sa-warning waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                class="icon-Trash1"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                    {!! $branches->withQueryString()->links('pagination::bootstrap-4') !!}

                </div>
            </div>
        </div>
    </section>
@endsection
@section('modal')
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-branch">

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $('#show-input').click(function() {
            $('#importFieldsFile').click()
        })
        $('#importFieldsFile').change(function() {
                var file_data = $('#importFieldsFile').prop('files')[0];
                var form_data = new FormData();
                form_data.append('file', file_data);
                form_data.append('_token', '{{ csrf_token() }}');
                $.ajax({
                    url: '{{ route('branch.uploadBranchExcelFile') }}',
                    dataType: 'text',
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: form_data,
                    type: 'post',
                    success: function(response) {
                       window.location.reload();
                    },
                    error: function(xhr, status, error) {
                        console.log(error);
                    }
                });
            });
    </script>
@endsection
