@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title">{{ trans('messages.Edit Settings') }}</h3>
            </div>

        </div>
    </div>

    <style>
        .bootstrap-tagsinput {
            width: 100%;
            padding: 0.6em;
        }
    </style>
    <!-- Main content -->

    <section class="content">
        {!! Form::open([
            'method' => 'PUT',
            'route' => ['setting.update', $settings->id],
            'files' => true,
            'id' => 'edit-settings-form',
        ]) !!}

        <div class="box">
            <div class="box-body">
                <div class="form-group">
                    <label for="facebook">{{ trans('messages.Facebook') }}
                    </label>
                    <div>
                        {!! Form::text('facebook', $settings->facebook, [
                            'class' => 'form-control',
                            'placeholder' => trans('messages.Facebook'),
                        ]) !!}
                    </div>
                    @error('facebook')
                        <div class="badge badge-danger text-center" style="width: 100%">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group">
                    <label for="instegram">{{ trans('messages.Instegram') }}
                    </label>
                    <div>
                        {!! Form::text('instegram', $settings->instegram, [
                            'class' => 'form-control',
                            'placeholder' => trans('messages.Instegram'),
                        ]) !!}
                    </div>
                    @error('instegram')
                        <div class="badge badge-danger text-center" style="width: 100%">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group">
                    <label for="tweetir">{{ trans('messages.Tweetir') }}
                    </label>
                    <div>
                        {!! Form::text('tweetir', $settings->tweetir, [
                            'class' => 'form-control',
                            'placeholder' => trans('messages.Tweetir'),
                        ]) !!}
                    </div>
                    @error('tweetir')
                        <div class="badge badge-danger text-center" style="width: 100%">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="linkedin">{{ trans('messages.Linkedin') }}
                    </label>
                    <div>
                        {!! Form::text('linkedin', $settings->linkedin, [
                            'class' => 'form-control',
                            'placeholder' => trans('messages.Linkedin'),
                        ]) !!}
                    </div>
                    @error('linkedin')
                        <div class="badge badge-danger text-center" style="width: 100%">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="youtube">{{ trans('messages.Youtube') }}
                    </label>
                    <div>
                        {!! Form::text('youtube', $settings->youtube, [
                            'class' => 'form-control',
                            'placeholder' => trans('messages.Youtube'),
                        ]) !!}
                    </div>
                    @error('youtube')
                        <div class="badge badge-danger text-center" style="width: 100%">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group">
                    <label for="name">{{ trans('messages.Privacy Policy') }}
                    </label>
                    <div>
                        {!! Form::select('privacy_id', $pages, $settings->privacy_id, [
                            'class' => 'form-control select2',
                            'style' => 'width:100%',
                            'data-placeholder' => trans('messages.Privacy Policy'),
                        ]) !!}
                    </div>
                </div>
                <div class="form-group">
                    <label for="name">{{ trans('messages.Terms and conditions') }}
                    </label>
                    <div>
                        {!! Form::select('terms_id', $pages, $settings->terms_id, [
                            'class' => 'form-control select2',
                            'style' => 'width:100%',
                            'data-placeholder' => trans('messages.Terms and conditions'),
                        ]) !!}

                    </div>

                </div>

            </div>
            <!-- /.box-body -->
            <div class="box-footer">
                <button type="submit" class="btn btn-rounded btn-primary btn-outline">
                    <i class="ti-save-alt"></i> {{ trans('messages.Save') }}
                </button>
            </div>
        </div>

        {!! Form::Close() !!}
    </section>
@endsection


@section('script')
    <script type="text/javascript">
        $('.select2').select2();
        CKEDITOR.replace('editor1')
        CKEDITOR.replace('editor2')
        $(document).ready(function() {
            $(window).keydown(function(event) {
                if (event.keyCode == 13) {
                    event.preventDefault();
                    return false;
                }
            });
        });
    </script>
@endsection
