<?php

namespace App\Providers;

use App\Models\Branch;
use App\Models\Form;
use App\Models\FormFixed;
use App\Models\FormInput;
use App\Models\FromFixedInputs;
use App\Models\NotificationBar;
use App\Models\Page;
use App\Models\Project;
use App\Models\ProjectFixed;
use App\Models\ProjectFixedInput;
use App\Models\ProjectForm;
use App\Models\ProjectFormInput;
use App\Models\Setting;
use App\Models\User;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Relation::enforceMorphMap([
            'branch' => Branch::class,
            'users'=>User::class,
            "form"=>Form::class,
            "fixed"=>FormFixed::class,
            "setting"=>Setting::class,
            "projectForm"=>ProjectForm::class,
            "projectFixed"=>ProjectFixed::class,
            "projects"=>Project::class,
            "Page"=>Page::class,
            "notification"=>NotificationBar::class,
            "ProjectFormInput"=>ProjectFormInput::class,
            "ProjectFixedInput"=>ProjectFixedInput::class,
            "fromInput"=>FormInput::class,
            "fixedInput"=>FromFixedInputs::class
        ]);
    }
}
