<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;

class Setting extends Model
{
    use HasFactory,LogsActivity;
    protected $fillable = [
        'facebook',
        'instegram',
        'tweetir',
        'linkedin',
        'youtube',
        'privacy_id',
        'terms_id',
    ];

    protected static $logName = 'setting';
    protected static $logAttributes = ['*'];
    protected static $ignoredAttributes = ['created_at', 'updated_at'];
    protected static $logOnlyDirty = true;
    public function privacy()
    {
        return $this->belongsTo(Page::class, 'privacy_id');
    }

    public function terms()
    {
        return $this->belongsTo(Page::class, 'terms_id');
    }
}
