<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class ProjectForm extends Model
{
    use HasFactory, softDeletes, LogsActivity;

    protected $fillable = [
        'serial_number',
        'expiration_date',
        'status',
    ];

    public $incrementing = true;

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->description =$eventName;
        $properties = $activity->properties->toArray();
        if (auth()->check()) {
            $causer = auth()->user();
            $gaurd = 'users';
        } elseif (auth('project')->check()) {
            $causer = auth('project')->user();
            $gaurd = 'projects';
        } elseif (auth('branches')->check()) {
            $causer = auth('branches')->user();
            $gaurd = 'branch';
        }
        if ($causer) {
            $activity->causer_type = $gaurd; // Type of the user (e.g., Admin, Project, Branch)
            $activity->causer_id = $causer->id; // ID of the user
        }


        $activity->properties = $properties;
    }

    protected static $logName = 'projectForm';
    protected static $ignoredAttributes = ['created_at', 'updated_at'];
    protected static $logAttributes = ['*'];

    protected static $logOnlyDirty = true;


    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function form()
    {
        return $this->belongsTo(Form::class);
    }

    public function projectFormInputs()
    {
        return $this->hasMany(ProjectFormInput::class);
    }
}
