<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class FromFixedInputs extends Model
{
    use LogsActivity;
    protected $table = 'form_inputs_fixed';


    protected static $logName = 'fixedInput';
    protected static $ignoredAttributes = ['created_at', 'updated_at'];
    protected static $logAttributes = ['*'];

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->description =$eventName;
        $properties = $activity->properties->toArray();
        if (auth()->check()) {
            $causer = auth()->user();
            $gaurd = 'users';
        } elseif (auth('project')->check()) {
            $causer = auth('project')->user();
            $gaurd = 'projects';
        } elseif (auth('branches')->check()) {
            $causer = auth('branches')->user();
            $gaurd = 'branch';
        }
        if ($causer) {
            $activity->causer_type = $gaurd; // Type of the user (e.g., Admin, Project, Branch)
            $activity->causer_id = $causer->id; // ID of the user
        }
        $properties['attributes'] = $this->attributesToArray();
        $properties['old'] = $this->getOriginal();

        $activity->from_id = $this->form_id;
        $activity->properties = $properties;
    }
    public function form()
    {
        return $this->belongsTo(FormFixed::class,'form_id');
    }
    public function inputsElemnts()
    {
        return $this->hasMany(fixedInputsElments::class,'input_id');
    }
}
