<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class FormFixed extends Model
{
    use HasFactory,softDeletes,LogsActivity;
    protected $table ="forms_fixed";

    protected static $logName = 'fixed';
    protected static $logAttributes = ['*'];
    protected static $ignoredAttributes = ['created_at', 'updated_at'];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->description =$eventName;
        $properties = $activity->properties->toArray();
        if (auth()->check()) {
            $causer = auth()->user();
            $gaurd = 'users';
        } elseif (auth('project')->check()) {
            $causer = auth('project')->user();
            $gaurd = 'projects';
        } elseif (auth('branches')->check()) {
            $causer = auth('branches')->user();
            $gaurd = 'branch';
        }
        if ($causer) {
            $activity->causer_type = $gaurd; // Type of the user (e.g., Admin, Project, Branch)
            $activity->causer_id = $causer->id; // ID of the user
        }
        $activity->properties = $properties;
    }
    public function formFiles()
    {
        return $this->hasMany(FormFixedFile::class,'form_id');
    }

    public function formInputs()
    {
        return $this->hasMany(FromFixedInputs::class,'form_id')->with('inputsElemnts');
    }
}
