<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Activitylog\Traits\LogsActivity;
use Tymon\JWTAuth\Contracts\JWTSubject;

class Branch  extends Authenticatable implements JWTSubject
{
    use HasFactory,LogsActivity;
    protected $table ="branches";
    protected $fillable = [
        'name','password','user_name','email','fcm_token','phone'
    ];
    protected $hidden = [
        'password'
    ];
    protected static $logName = 'branch';
    protected static $logAttributes = ['*'];
    protected static $ignoredAttributes = ['created_at', 'updated_at'];
    protected static $logOnlyDirty = true;



    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }

    public function projects()
    {
        return $this->hasMany(Project::class);
    }
}
