<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Page;
use App\Models\ProjectForm;
use App\Models\ProjectFormInput;
use Illuminate\Http\Request;

class ProjectFormController extends Controller
{
    public function getProjectForms(Request $request)
    {

        $name = ($request->has('search_word')) ? $request->search_word : null;
        $serial_number = ($request->has('serial_number')) ? $request->serial_number : null;
        $status = ($request->has('status')) ? $request->status : null;
        if ($request->date_rang) {
            $date_rang = explode('-', $request->date_rang);
            $from = date('Y-m-d', strtotime($date_rang[0]));
            $to = date('Y-m-d', strtotime($date_rang[1]));
        } else {
            $from = null;
            $to = null;
        }

        $forms = ProjectForm::where('project_id', auth('project')->user()->id)
            ->when($status, function ($q, $status) {
                $q->whereIn('status', explode(',', $status));
            })
            ->when($name, function ($q, $name) {
                $q->whereHas('form', function ($q) use ($name) {
                    $q->where('name', 'like', '%' . $name . '%');
                });
            })
            ->when($serial_number, function ($q, $serial_number) {
                $q->where('serial_number', 'like', '%' . $serial_number . '%');
            })
            ->when($from && $to, function ($q) use ($from, $to) {
                $q->whereBetween('created_at', [$from, $to]);
            })->orderBy('updated_at', 'desc')->paginate(10);

        return view('front_end.partial.formdLazyload', compact('forms'));
    }

    public function fillForm(Request $request, $project_form_id)
    {
        if ($request->page) {
            $page = $request->page;
        } else {
            $page = 1;
        }
        $projectForm = ProjectForm::with('form')->where('id', $request->project_form_id)
            ->with('form.formFiles')
            ->first();
        $formInputs = ProjectFormInput::with('formInput')
            ->where('project_form_id', $project_form_id)
            ->paginate(5, ['*'], 'page', $page);
        $totalPages = $formInputs->lastPage();
        if ($page == $totalPages) {
            $show_submit = 1;
        } else {
            $show_submit = 0;
        }
        $totalInputs = ProjectFormInput::with('formInput')->where('project_form_id', $project_form_id)->count();
        $currentInputsNum = $formInputs->count() + (($formInputs->currentPage() - 1) * 5);
        $currentPage = $formInputs->currentPage();
        $nextPage = $currentPage + 1;
        $prevPage = $currentPage - 1;
        $hasMorePages = $formInputs->hasMorePages();

        return view('front_end.fill_form', compact('formInputs', 'nextPage', 'prevPage', 'show_submit', 'totalPages', 'project_form_id', 'projectForm', 'totalInputs', 'currentInputsNum'));
    }

    public function viewForm(Request $request, $project_form_id)
    {
        if ($request->page) {
            $page = $request->page;
        } else {
            $page = 1;
        }
        $projectForm = ProjectForm::with('form')->where('id', $request->project_form_id)
            ->with('form.formFiles')
            ->first();
        $formInputs = ProjectFormInput::with('formInput')
            ->where('project_form_id', $project_form_id)
            ->paginate(5, ['*'], 'page', $page);
        $totalPages = $formInputs->lastPage();
        $totalInputs = ProjectFormInput::with('formInput')->where('project_form_id', $project_form_id)->count();
        $currentInputsNum = $formInputs->count() + (($formInputs->currentPage() - 1) * 5);
        $currentPage = $formInputs->currentPage();
        $nextPage = $currentPage + 1;
        $prevPage = $currentPage - 1;
        $hasMorePages = $formInputs->hasMorePages();

        return view('front_end.view_form', compact('formInputs', 'nextPage', 'prevPage', 'totalPages', 'project_form_id', 'projectForm', 'totalInputs', 'currentInputsNum'));
    }

    public function submitFillForm(Request $request)
    {


        foreach ($request->inputs as $key => $value) {
            $projectFormInput = ProjectFormInput::find($key);
            switch ($value['type']) {
                case 'file':
                    if (isset($value['answer'])) {
                        $file_path_ext = saveFileForm($value['answer'], 'projectForms');
                        $projectFormInput->answer = $file_path_ext['path'];
                        $projectFormInput->file_type = $file_path_ext['ext'];
                    }
                    break;
                default:
                    $projectFormInput->answer = isset($value['answer'])?$value['answer'] :null;
                    break;
            }
            $projectFormInput->save();
        }
        $checkFormDone = ProjectFormInput::where('project_form_id', $request->project_form_id)->whereNotIn('input_type',['checkbox','radio','file'])->whereNull('answer')->get();
        $projectForm = ProjectForm::find($request->project_form_id);
        if (sizeof($checkFormDone) > 0) {
            $projectForm->status = 'incomplete';
            $projectForm->save();
        } else {
            $projectForm->status = $projectForm->form->approved == 1 ? "waiting approved" : "done";
            $projectForm->save();
        }
        if ($request->show_submit == 1 && $request->submit_type == 'submit') {
            if (sizeof($checkFormDone) > 0) {
                return redirect()->route('home');
            } else {
                return redirect()->route('home', ['type' => 'history']);
            }
        } else {
            if ($request->submit_type == 'prev') {
                return redirect()->route('fillForm', ['project_form_id' => $request->project_form_id, 'page' => $request->prevPage]);
            } else {
                return redirect()->route('fillForm', ['project_form_id' => $request->project_form_id, 'page' => $request->nextPage]);
            }
        }
        return $request;
    }
}
