<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\FormFixed;
use App\Models\FromFixedInputs;
use App\Models\ProjectFixed;
use App\Models\ProjectFixedInput;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;

class FormFixedController extends Controller
{

    public function index(Request $request)
    {
        if ($request->has('type')) {
            $type = $request->type;
        } else {
            $type = null;
        }
        return view('front_end.fixed.index', compact('type'));
    }

    public function fixedGet()
    {

        $forms = FormFixed::orderBy('created_at', 'desc');
        if (request()->has('search_word')) {
            $sort_search = request()->search_word;
            $forms = $forms->where('name', 'like', '%' . $sort_search . '%');
        }
        $forms = $forms->paginate(10);

        return view('front_end.fixed.all-forms', compact('forms'));
    }

    public function fixedHistory()
    {
        $name = (request()->has('search_word')) ? request()->search_word : null;
        $status = (request()->has('status')) ? request()->status : null;
        if (request()->date_rang) {
            $date_rang = explode('-', request()->date_rang);
            $from = date('Y-m-d', strtotime($date_rang[0]));
            $to = date('Y-m-d', strtotime($date_rang[1]));
        } else {
            $from = null;
            $to = null;
        }
        $project_id = Auth()->guard('project')->check() ?auth('project')->user()->id :null;
        $forms = ProjectFixed::with('Form', 'Project', 'Branch')
            ->when($status, function ($q, $status) {
                $q->whereIn('status', explode(',', $status));
            })
            ->when($name, function ($q, $name) {
                $q->whereHas('Form', function ($q) use ($name) {
                    $q->where('name', 'like', '%' . $name . '%');
                });
            })->when($from && $to, function ($q) use ($from, $to) {
                $q->whereBetween('created_at', [$from, $to]);
            })->when($project_id, function ($q) use ($project_id) {
                $q->where('project_id', $project_id);
            })->orderBy('updated_at', 'desc')->paginate(10);

        $color =['done'=>'bg-green',
            'rejected'=>"bg-red",
            'approved'=>"bg-green",
            'waiting'=>"bg-blue",
            'open'=>"bg-blue",
        ];
        return view('front_end.fixed.history', compact('forms','color'));
    }

    public function fillForm(Request $request, $form_id)
    {
        if ($request->page) {
            $page = $request->page;
        } else {
            $page = 1;
        }
        $projectForm = FormFixed::find($form_id);
        if (!empty($projectForm)) {
            $formInputs = FromFixedInputs::with('inputsElemnts')
                ->where('form_id', $form_id)
                ->paginate(5, ['*'], 'page', $page);
            $totalPages = $formInputs->lastPage();
            if ($page == $totalPages) {
                $show_submit = 1;
            } else {
                $show_submit = 0;
            }
            $totalInputs = $formInputs->total();
            $currentInputsNum = $formInputs->count() + (($formInputs->currentPage() - 1) * 5);
            $currentPage = $formInputs->currentPage();
            $nextPage = $currentPage + 1;
            $prevPage = $currentPage - 1;
            $hasMorePages = $formInputs->hasMorePages();
            // set session with type and input id and answer
            $formData = session()->get('form_data', []);
            if (isset($formData['form']) && $formData['form'] != $form_id) {
                session()->forget('form_data');
                $formData = session()->get('form_data', []);
            }
            $formData['form'] = $form_id;
            foreach ($formInputs as $input) {
                $formData[$input->id] = [
                    'answer' => null,
                    'type' => $input->input_type,
                    'file_type' => null,
                    'calculated' => $input->calculated
                ];

            }
            session()->put('form_data', $formData);
            $myforms = session()->get('form_data');
            return view('front_end.fixed.fill_form', compact('myforms', 'formInputs', 'nextPage', 'prevPage', 'show_submit', 'totalPages', 'form_id', 'projectForm', 'totalInputs', 'currentInputsNum'));

        }

        return redirect()->back();


    }

    public function submitForm(Request $request, $form_id)
    {

        $formData = session()->get('form_data');
        foreach ($request->inputs as $key => $input) {
            if ($input['type'] == 'file') {
                if(isset($input['answer']))
                {
                    $file_path_ext = saveFileForm($input['answer'], 'projectForms');
                    $formData[$key]['answer'] = $file_path_ext['path'];
                    $formData[$key]['file_type'] = $file_path_ext['ext'];
                }else{
                    $formData[$key]['answer'] = null;
                    $formData[$key]['file_type'] = null;
                }

            } else {
                $formData[$key]['answer'] = $input['answer']??null;
            }

        }
        session()->put('form_data', $formData);

        if ($request->show_submit == 1 && $request->submit_type == 'submit') {
            // save data
            $form = FormFixed::find($form_id);
            $inputs = session()->get('form_data');
            $inputs = Arr::except($inputs, ['form']);
            $fixed = new ProjectFixed();
            $fixed->form_id = $form_id;
            $fixed->project_id = auth('project')->user()->id;
            $fixed->branch_id = auth('project')->user()->branch_id;
            $fixed->status = $form->approved == 1 ? "waiting" : "done";
            if ($fixed->save()) {
                foreach ($inputs as $key => $input) {
                    $in = new ProjectFixedInput();
                    $in->project_fixed_id = $fixed->id;
                    $in->fixed_input_id = (int)$key;
                    $in->answer = is_array($input['answer']) ? json_encode($input['answer']) : $input['answer'];
                    $in->input_type = $input['type'];
                    $in->file_type = $input['file_type'];
                    $in->calculated = $input['calculated'];
                    $in->save();
                }
                // updated Form Fixed to compleated to to Deleted it :)
                $form->step = 'compleated';
                $form->save();
            }

            session()->forget('form_data');
            return redirect()->route('front.fixed.index', ['type' => 'history']);
        } else {
            if ($request->submit_type == 'prev') {
                return redirect()->route('front.fixed.fillForm', ['id' => $request->project_form_id, 'page' => $request->prevPage]);
            } else {
                return redirect()->route('front.fixed.fillForm', ['id' => $request->project_form_id, 'page' => $request->nextPage]);
            }
        }
        return $request;
    }

    public function viewForm($id)
    {
        if (request()->has('page')) {
            $page = request()->page;
        } else {
            $page = 1;
        }
        $projectForm = ProjectFixed::with('Form.formFiles')->find($id);
        if (!empty($projectForm)) {
            $formInputs = FromFixedInputs::with('inputsElemnts')
                ->where('form_id', $projectForm->form->id)
                ->paginate(5, ['*'], 'page', $page);

            // user aswer
            $inputs = ProjectFixedInput::where('project_fixed_id', $projectForm->id)->get();
            $totalPages = $formInputs->lastPage();
            if ($page == $totalPages) {
                $show_submit = 1;
            } else {
                $show_submit = 0;
            }
            $totalInputs = $formInputs->total();
            $currentInputsNum = $formInputs->count() + (($formInputs->currentPage() - 1) * 5);
            $currentPage = $formInputs->currentPage();
            $nextPage = $currentPage + 1;
            $prevPage = $currentPage - 1;
            $hasMorePages = $formInputs->hasMorePages();
            return view('front_end.fixed.form_view', compact('inputs', 'formInputs', 'nextPage', 'prevPage', 'show_submit', 'totalPages', 'id', 'projectForm', 'totalInputs', 'currentInputsNum'));

        }

        return redirect()->back();


    }
}

