<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\FromFixedInputs;
use App\Models\Project;
use App\Models\ProjectFixed;
use App\Models\ProjectFixedInput;
use App\Models\ProjectForm;
use App\Models\ProjectFormInput;
use Illuminate\Http\Request;

class BranchFrontController extends Controller
{

    public function index(Request $request)
    {
        if ($request->has('type')) {
            $type = $request->type;
        } else {
            $type = 'general';
        }

        $projects = Project::where('branch_id', auth('branches')->user()->id)->get();
        return view('front_end.branch.index', compact('type', 'projects'));
    }

    public function fixed()
    {
        $name = (request()->has('search_word')) ? request()->search_word : null;
        $status = (request()->has('status')) ? request()->status : null;
        if (request()->date_rang) {
            $date_rang = explode('-', request()->date_rang);
            $from = date('Y-m-d', strtotime($date_rang[0]));
            $to = date('Y-m-d', strtotime($date_rang[1]));
        } else {
            $from = null;
            $to = null;
        }
        $project_id = request()->has('projectId') && request()->projectId != null ? [(int)request()->projectId] : null;
        $branch = Auth()->guard('branches')->check() ? auth('branches')->user()->id : null;
        $forms = ProjectFixed::with('Form', 'Project', 'Branch')
            ->when($status, function ($q, $status) {
                $q->whereIn('status', explode(',', $status));
            })
            ->when($name, function ($q, $name) {
                $q->whereHas('Form', function ($q) use ($name) {
                    $q->where('name', 'like', '%' . $name . '%');
                });
            })->when($from && $to, function ($q) use ($from, $to) {
                $q->whereBetween('created_at', [$from, $to]);
            })->when($project_id, function ($q) use ($project_id) {
                $q->where('project_id', $project_id);
            })->when($branch, function ($q) use ($branch) {
                $q->where('branch_id', $branch);
            })->orderBy('updated_at', 'desc')->paginate(10);

        $color = [
            'done' => 'bg-green',
            'rejected' => "bg-red",
            'approved' => "bg-green",
            'waiting' => "bg-blue",
            'open' => "bg-purple",
        ];
        return view('front_end.branch.fixed', compact('forms', 'color'));
    }

    public function form(Request $request)
    {

        $name = ($request->has('search_word')) ? $request->search_word : null;
        $serial_number = ($request->has('serial_number')) ? $request->serial_number : null;
        $status = ($request->has('status')) ? $request->status : null;

        if ($request->date_rang) {
            $date_rang = explode('-', $request->date_rang);
            $from = date('Y-m-d', strtotime($date_rang[0]));
            $to = date('Y-m-d', strtotime($date_rang[1]));
        } else {
            $from = null;
            $to = null;
        }

        $branchs = $request->has('projectId') && $request->projectId != null ? [(int)$request->projectId] : Project::where('branch_id', auth('branches')->user()->id)->pluck('id')->toArray();

        $forms = ProjectForm::whereIn('project_id', $branchs)
            ->when($status, function ($q, $status) {
                $q->whereIn('status', explode(',', $status));
            })
            ->when($name, function ($q, $name) {
                $q->whereHas('form', function ($q) use ($name) {
                    $q->where('name', 'like', '%' . $name . '%');
                });
            })
            ->when($serial_number, function ($q, $serial_number) {
                $q->where('serial_number', 'like', '%' . $serial_number . '%');
            })
            ->when($from && $to, function ($q) use ($from, $to) {
                $q->whereBetween('created_at', [$from, $to]);
            })->orderBy('updated_at', 'desc')
            ->paginate(10);

        $color = ['done' => 'bg-green',
            'rejected' => "bg-red",
            'approved' => "bg-green",
            'waiting approved' => "bg-blue",
            'waiting' => "bg-dark",
            'open' => "bg-dark",
            'incomplete' => "bg-purple",
            'expired' => "bg-red",
        ];
        return view('front_end.branch.form', compact('forms', 'color'));
    }

    public function fromView($id)
    {

        $projectForm = ProjectForm::where('id', $id)
            ->with('form.formFiles')
            ->first();
        $formInputs = ProjectFormInput::with('formInput')
            ->where('project_form_id', $id)
            ->paginate(5);


        $totalPages = $formInputs->lastPage();
        $show_submit = $formInputs->nextPageUrl() == null ? 1 : 0;
        $totalInputs = ProjectFormInput::with('formInput')->where('project_form_id', $id)->count();
        $currentInputsNum = $formInputs->count() + (($formInputs->currentPage() - 1) * 5);
        $currentPage = $formInputs->currentPage();
        $nextPage = $currentPage + 1;
        $prevPage = $currentPage - 1;
        $hasMorePages = $formInputs->hasMorePages();

        return view('front_end.branch.fromView', compact('show_submit', 'projectForm', 'formInputs', 'totalPages', 'totalInputs', 'currentInputsNum', 'nextPage', 'prevPage', 'currentPage'));
    }

    public function submitForm(Request $request, $id)
    {
        foreach ($request->inputs as $key => $value) {
            $projectFormInput = ProjectFormInput::find($key);
            switch ($value['type']) {
                case 'file':
                    if (isset($value['answer'])) {
                        $file_path_ext = saveFileForm($value['answer'], 'projectForms');
                        $projectFormInput->answer = $file_path_ext['path'];
                        $projectFormInput->file_type = $file_path_ext['ext'];
                    }
                    break;
                default:
                    $projectFormInput->answer = isset($value['answer']) ? $value['answer'] : null;
                    break;
            }
            $projectFormInput->save();
        }
        $checkFormDone = ProjectFormInput::where('project_form_id', $id)->whereNotIn('input_type', ['checkbox', 'radio', 'file'])->whereNull('answer')->get();
        $projectForm = ProjectForm::find($id);
        if (sizeof($checkFormDone) > 0) {
            $projectForm->status = 'incomplete';
            $projectForm->save();
        } else {
            $projectForm->status = $projectForm->form->approved == 1 ? "waiting approved" : "done";
            $projectForm->save();
        }
        if ($request->show_submit == 1 && $request->submit_type == 'submit') {
            return redirect()->route('branch.front.index', ['type' => 'general']);
        } else {
            if ($request->submit_type == 'prev') {
                return redirect()->route('branch.front.formView', ['id' => $id, 'page' => $request->prevPage]);
            } else {
                return redirect()->route('branch.front.formView', ['id' => $id, 'page' => $request->nextPage]);
            }
        }
        return $request;
    }


    public function ChangeStatusFrom($id, $status)
    {
        $projectForm = ProjectForm::find($id);
        if (!empty($projectForm)) {
            $projectForm->status = $status;
            $projectForm->save();
            return redirect()->route('branch.front.index', ['type' => 'general']);
        }
        return redirect()->back();
    }

    public function fixedView($id)
    {
        $projectForm = ProjectFixed::with('Form.formFiles')->find($id);
        if (!empty($projectForm)) {
            $formInputs = FromFixedInputs::with('inputsElemnts')
                ->where('form_id', $projectForm->form->id)
                ->paginate(5);

            $inputs = ProjectFixedInput::where('project_fixed_id', $projectForm->id)->get();
            $totalInputs = $formInputs->total();
            $totalPages = $formInputs->lastPage();
            $currentInputsNum = $formInputs->count() + (($formInputs->currentPage() - 1) * 5);
           $currentPage = $formInputs->currentPage();
            $nextPage = $currentPage + 1;
            $prevPage = $currentPage - 1;
            $hasMorePages = $formInputs->hasMorePages();
            $show_submit = $formInputs->nextPageUrl() == null ? 1 : 0;
            return view('front_end.branch.fixedView', compact('show_submit', 'inputs', 'formInputs', 'nextPage', 'totalPages', 'prevPage', 'id', 'projectForm', 'totalInputs', 'currentInputsNum'));
        }

        return redirect()->back();
    }

    public function fixedSubmit(Request $request, $id)
    {
        foreach ($request->inputs as $key => $value) {
            $projectFormInput = ProjectFixedInput::find($key);
            switch ($value['type']) {
                case 'file':
                    if (isset($value['answer'])) {
                        $file_path_ext = saveFileForm($value['answer'], 'projectForms');
                        $projectFormInput->answer = $file_path_ext['path'];
                        $projectFormInput->file_type = $file_path_ext['ext'];
                    }
                    break;
                default:
                    $projectFormInput->answer = isset($value['answer']) ? $value['answer'] : null;
                    break;
            }
            $projectFormInput->save();
        }

        if ($request->show_submit == 1 && $request->submit_type == 'submit') {
            return redirect()->route('branch.front.index', ['type' => 'fixed']);
        } else {
            if ($request->submit_type == 'prev') {
                return redirect()->route('branch.front.fixedView', ['id' => $id, 'page' => $request->prevPage]);
            } else {
                return redirect()->route('branch.front.fixedView', ['id' => $id, 'page' => $request->nextPage]);
            }
        }
        return $request;
    }

    public function ChangeStatusFixed($id, $status)
    {
        $projectForm = ProjectFixed::find($id);
        if (!empty($projectForm)) {
            $projectForm->status = $status;
            $projectForm->save();
            return redirect()->route('branch.front.index', ['type' => 'fixed']);
        }
        return redirect()->back();
    }

  public function DelFrom($id)
  {
      $form = ProjectForm::find($id);
      if(!empty($form))
      {
          $form->delete();
          return redirect()->back();
      }
      return redirect()->back();
  }

    public function del($id)
    {
        $form = ProjectFixed::find($id);
        if(!empty($form))
        {
            $form->delete();
            return redirect()->back();
        }
        return redirect()->back();
    }
}
