<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use App\Models\Project;
use Illuminate\Http\Request;
use Auth;

class ProjectAuthController extends Controller
{
    public function login(Request $request)
    {
        // return $request;
        $credentials = $request->only('project_id', 'password');
        $project = Project::where('id', $credentials['project_id'])->first();
        if (!$project || !password_verify($credentials['password'], $project->password)) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid password',
            ]);
        }
        Auth::guard('project')->login($project);
        return redirect()->route('choseFrom');
    }

    public function showLoginForm()
    {
        $branches = Branch::pluck('name', 'id');
        if (sizeof($branches) > 0) {
            $projects = Project::where('branch_id', $branches->keys()->first())->pluck('name', 'id');
        } else {
            $projects = [];
        }
        return view('auth.project-login', compact('branches', 'projects'));
    }
}
