<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\FixedFormCollection;
use App\Models\FormFixed;
use App\Models\ProjectFixed;
use App\Models\ProjectFixedInput;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class FromFixedController extends Controller
{

    public function index()
    {
        $name =request()->has('name') ? request('name') : null;
        $type =request()->has('type') ? request('type'):'new';
        $status =request()->has('status') && request('status') !=null ? request('status'):null;
        $from =request()->has('from') ? request('from'):null;
        $to =request()->has('to') ? request('to'):null;
        $project_id =Auth::guard('api')->user()->id;

        if($type == 'new')
        {
            $froms = FormFixed::when($name, function ($q, $name) {
                    $q->where('name', 'like', '%' . $name . '%');
                })->when($from && $to, function ($q) use ($from, $to) {
                $q->whereBetween('created_at', [$from, $to]);
            })->orderBy('created_at', 'desc')->paginate(10);

        }else{
            $froms = ProjectFixed::with('Form', 'Project', 'Branch')->orderBy('created_at', 'desc')
                ->when($status, function ($q, $status) {
                    $q->whereIn('status', explode(',', $status));
                })
                ->when($name, function ($q, $name) {
                    $q->whereHas('Form', function ($q) use ($name) {
                        $q->where('name', 'like', '%' . $name . '%');
                    });
                })->when($from && $to, function ($q) use ($from, $to) {
                    $q->whereBetween('created_at', [$from, $to]);
                })->when($project_id, function ($q) use ($project_id) {
                    $q->where('project_id', $project_id);
                })->paginate(10);
        }

        $data =  new FixedFormCollection($froms, $type);
        return response()->json(['success' => true, 'forms' => $data]);

    }

    public function getFixedFields()
    {

        $project = request()->has('project_form_id') && request('project_form_id')  !=null ? request('project_form_id') : null;
        $fixedFromId = request()->has('id') ? request('id') : null;

        // check Created project fixed From
        if($fixedFromId != null && $project == null)
        {

            $myFrom = FormFixed::with('formInputs')->find($fixedFromId);
            if(!empty($myFrom))
            {
                // created data
                $myinputs =$myFrom->formInputs;
                $fixed = new ProjectFixed();
                $fixed->form_id = $fixedFromId;
                $fixed->project_id = Auth::guard('api')->user()->id;
                $fixed->branch_id = Auth::guard('api')->user()->branch_id;
                $fixed->status = "open";
                if($fixed->save())
                {
                    foreach ($myinputs as $myinput)
                    {
                        $in = new ProjectFixedInput();
                        $in->project_fixed_id = $fixed->id;
                        $in->fixed_input_id = $myinput->id;
                        $in->answer = null;
                        $in->input_type = $myinput->input_type;
                        $in->file_type = null;
                        $in->calculated = $myinput->calculated;
                        $in->save();
                    }
                    $myFrom->step = 'compleated';
                    $myFrom->save();
                    $project=$fixed->id;
                }
            }
        }
        // get Data

        $projectForm = ProjectFixed::where('id', $project)
            ->with('form.formFiles')
            ->first();

        $formInputs = ProjectFixedInput::with('formInput')
            ->where('project_fixed_id', $project)
            ->paginate(5);

        return response()->json(['success' => true, 'inputs' => $formInputs, 'projectForm' => $projectForm]);
    }

    public function submitFormInputs(Request $request)
    {
        foreach ($request->inputs as $key => $value) {
            $projectFormInput = ProjectFixedInput::find($value['id']);
            switch ($value['type']) {
                case 'file':
                    if (in_array($value['value']['mime'], ['image/jpeg', 'image/jpg', 'image/png', 'application/pdf'])) {
                        $file_path = uploadFile($value['value']['data'], $value['value']['mime']);
                        $projectFormInput->answer = $file_path;
                        $projectFormInput->file_type = $value['value']['mime'];
                    } else {
                        return response()->json(['success' => false, 'message' => 'The ' . $value['value']['mime'] . ' not supported']);
                    }
                    break;
                default:
                    $projectFormInput->answer = $value['value'];
                    break;
            }
            $projectFormInput->save();
        }

        $checkFormDone = ProjectFixedInput::where('project_fixed_id', $request->project_form_id)->whereNotIn('input_type',['checkbox','radio','file'])->whereNull('answer')->get();
        $projectFormUpdate = ProjectFixed::with('Form')->find($request->project_form_id);
        if (sizeof($checkFormDone) > 0) {
            $projectFormUpdate->status = 'open';
            $projectFormUpdate->save();
        } else {
            $projectFormUpdate->status =$projectFormUpdate->Form->approved == 0 ?'done':"waiting";
            $projectFormUpdate->save();
        }

        $projectForm = ProjectFixed::where('id', $request->project_form_id)
            ->with('form.formFiles')
            ->first();

        switch ($request->next_prev) {
            case 'next':
                if ($request->next_page_url != null) {
                    $formInputs = ProjectFixedInput::with('formInput')
                        ->where('project_fixed_id', $request->project_form_id)
                        ->paginate(5, ['*'], 'page', $request->next_page_url);
                }
                else {
                    $formInputs = null;
                }
                return response()->json(['success' => true, 'inputs' => $formInputs, 'projectForm' => $projectForm]);
                break;
            case 'prev':
                if ($request->prev_page_url != null) {
                    $formInputs = ProjectFixedInput::with('formInput')
                        ->where('project_fixed_id', $request->project_form_id)
                        ->paginate(5, ['*'], 'page', $request->prev_page_url);
                }
                else {
                    $formInputs = null;
                }
                return response()->json(['success' => true, 'inputs' => $formInputs, 'projectForm' => $projectForm]);
                break;

            default:
                # code...
                break;
        }
        return response()->json(['success' => true, 'inputs' => null, 'projectForm' => $projectForm]);
    }

}
