<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Form;
use App\Models\ProjectForm;
use App\Models\ProjectFormInput;
use Illuminate\Http\Request;

class FormController extends Controller
{
    public function projectForms(Request $request)
    {
        /*
        
          ->when($status, function ($q, $status) {
                $q->whereIn('status', explode(',', $status));
            })
        
        */
        $name = ($request->has('name')) ? $request->name : null;
        $serial_number = ($request->has('serial_number')) ? $request->serial_number : null;
        $status = ($request->has('status')) ? $request->status : null;
        $from = ($request->has('from')) ? $request->from : null;
        $to = ($request->has('to')) ? date('Y-m-d', strtotime($request->to . ' +1 day')) : null;

        $forms = ProjectForm::where('project_id', auth('api')->user()->id)
              ->when($status, function ($q, $status) {
                $statusArray = explode(',', $status);
                if (in_array('done', $statusArray)) {
                    $statusArray[] = 'waiting approved';
                }
                $q->whereIn('status', $statusArray);
            })
            ->when($name, function ($q, $name) {
                $q->whereHas('form', function ($q) use ($name) {
                    $q->where('name', 'like', '%' . $name . '%');
                });
            })
            ->when($serial_number, function ($q, $serial_number) {
                $q->where('serial_number', 'like', '%' . $serial_number . '%');
            })
            ->when($from && $to, function ($q) use ($from, $to) {
                $q->whereBetween('created_at', [$from, $to]);
            })
            ->with('form')
            ->orderBy('updated_at', 'desc')
            ->paginate(10);

        return response()->json(['success' => true, 'forms' => $forms]);
    }

    public function getFormFields(Request $request)
    {
        $projectForm = ProjectForm::where('id', $request->project_form_id)
            ->with('form.formFiles')
            ->first();
        $formInputs = ProjectFormInput::with('formInput')
            ->where('project_form_id', $request->project_form_id)
            ->paginate(5);

        return response()->json(['success' => true, 'inputs' => $formInputs, 'projectForm' => $projectForm]);
    }

    public function submitFormInputs(Request $request)
    {
        foreach ($request->inputs as $key => $value) {
            $projectFormInput = ProjectFormInput::find($value['id']);
            switch ($value['type']) {
                case 'file':
                    if (in_array($value['value']['mime'], ['image/jpeg', 'image/jpg', 'image/png', 'application/pdf'])) {
                        $file_path = uploadFile($value['value']['data'], $value['value']['mime']);
                        $projectFormInput->answer = $file_path;
                        $projectFormInput->file_type = $value['value']['mime'];
                    } else {
                        return response()->json(['success' => false, 'message' => 'The ' . $value['value']['mime'] . ' not supported']);
                    }
                    break;
                default:
                    $projectFormInput->answer = $value['value'];
                    break;
            }
            $projectFormInput->save();
        }
        $checkFormDone = ProjectFormInput::where('project_form_id', $request->project_form_id)->whereNotIn('input_type',['checkbox','radio','file'])->whereNull('answer')->get();
        $projectFormUpdate = ProjectForm::find($request->project_form_id);
        if (sizeof($checkFormDone) > 0) {
            $projectFormUpdate->status = 'incomplete';
            $projectFormUpdate->save();
        } else {
            $projectFormUpdate->status =$projectFormUpdate->form->approved == 1 ? 'waiting approved' :'done';
            $projectFormUpdate->save();
        }

        $projectForm = ProjectForm::where('id', $request->project_form_id)
            ->with('form.formFiles')
            ->first();
        switch ($request->next_prev) {
            case 'next':
                if ($request->next_page_url != null) {
                    $formInputs = ProjectFormInput::with('formInput')
                        ->where('project_form_id', $request->project_form_id)
                        ->paginate(5, ['*'], 'page', $request->next_page_url);
                } else {
                    $formInputs = null;
                }
                return response()->json(['success' => true, 'inputs' => $formInputs, 'projectForm' => $projectForm]);
                break;

            case 'prev':
                if ($request->prev_page_url != null) {
                    $formInputs = ProjectFormInput::with('formInput')
                        ->where('project_form_id', $request->project_form_id)
                        ->paginate(5, ['*'], 'page', $request->prev_page_url);
                } else {
                    $formInputs = null;
                }
                return response()->json(['success' => true, 'inputs' => $formInputs, 'projectForm' => $projectForm]);
                break;

            default:
                # code...
                break;
        }
        return response()->json(['success' => true, 'inputs' => null, 'projectForm' => $projectForm]);
    }
}
