<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\NotificationBar;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class NotificationBarController extends Controller
{

    public function index()
    {
        $notifications = NotificationBar::orderBy('updated_at', 'desc');

        $notifications= $notifications->paginate(15);
        return view('admin.notificationbar.index', compact('notifications'));

    }

    public function create(){
        return view('admin.notificationbar.add');
    }

    public function store(Request $request)
    {
        $request->validate([
            'text' => 'required|string',
        ]);

        $bar = new NotificationBar();
        $bar->text = $request->text;
        $bar->active = $request->active;
        if($bar->save()){
            session()->flash('notif', trans('messages.Added successfully.'));
            return redirect()->route('notificationbar.index');
        }

        return redirect()->back();
    }

    public function updated($id)
    {
        $bar = NotificationBar::find($id);
        if(!empty($bar))
            return view('admin.notificationbar.updated', compact('bar'));



        session()->flash('notif', trans('Not found.'));
        return redirect()->route('notificationbar.index');
    }

    public function updatedSave(Request $request, $id)
    {
        $bar = NotificationBar::find($id);
        if(!empty($bar))
        {
            $request->validate([
                'text' => 'required|string',
            ]);

            $bar->text = $request->text;
            $bar->active = $request->active;
            if($bar->save()){
                session()->flash('notif', trans('messages.Edited successfully.'));
                return redirect()->route('notificationbar.index');
            }

            return redirect()->back();
        }

        session()->flash('notif', trans('Not found.'));
        return redirect()->route('notificationbar.index');
    }

    public function del($id = 0)
    {
        $bar = NotificationBar::find($id);
        if(!empty($bar))
        {
            $bar->delete();
            session()->flash('notif', trans('messages.Edited successfully.'));
            return redirect()->route('notificationbar.index');
        }

        session()->flash('notif', trans('Not found.'));
        return redirect()->route('notificationbar.index');


    }
}
