<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use App\Models\Form;
use App\Models\Project;
use App\Models\ProjectForm;
use Illuminate\Http\Request;
use Carbon\Carbon;

class HomeController extends Controller
{
    public function dashboard()
    {
        $Expirforms = ProjectForm::where('expiration_date', '<', Carbon::now())->whereIn('status', ['waiting', 'incomplete'])->get();
        $publishForms = Form::where('nex_send_date', date('Y-m-d'))->orWhere('one_type_send_time', date('Y-m-d'))->get();
        $formsCount = Form::count();
        $SendedFormsCount = ProjectForm::count();
        $branchesCount = Branch::count();
        $projectsCount = Project::count();
        $forms = ProjectForm::orderBy('created_at', 'desc')->take(10)->get();
        return view('admin.dashboard', compact('Expirforms', 'publishForms', 'forms','formsCount','SendedFormsCount','branchesCount','projectsCount'));
    }
}
