<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use App\Models\FormFile;
use App\Http\Requests\StoreFormFileRequest;
use App\Http\Requests\UpdateFormFileRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;

class FormFileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $files = FormFile::where('temp_serial', $request->temp_serial)->get();
        return view('admin.formFile.index', compact('files'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreFormFileRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreFormFileRequest $request)
    {
        $file = $request->file('file');
        $uploadedFile = saveFormFile($file);
        if ($uploadedFile['success'] == true) {
            $formFile = new FormFile;
            $formFile->temp_serial  = $request->temp_serial;
            $formFile->type  = $uploadedFile['file_type'];
            $formFile->file_path  = 'uploads/formFiles/' . $uploadedFile['file_name'];
            $formFile->save();
            return response()->json(['success' => true, 'data' => $uploadedFile]);
        } else {
            return response()->json(['success' => false, 'data' => null]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\FormFile  $formFile
     * @return \Illuminate\Http\Response
     */
    public function show(FormFile $formFile)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\FormFile  $formFile
     * @return \Illuminate\Http\Response
     */
    public function edit(FormFile $formFile)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateFormFileRequest  $request
     * @param  \App\Models\FormFile  $formFile
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateFormFileRequest $request, FormFile $formFile)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\FormFile  $formFile
     * @return \Illuminate\Http\Response
     */
    public function destroy(FormFile $formFile)
    {
        // return $formFile;
        $formFile->delete();
        $files = FormFile::where('temp_serial', Session::get('temp_serial'))->get();
        return view('admin.formFile.index', compact('files'));
    }

    public function delete(Request $request)
    {
        // return $formFile;
        $formFile = FormFile::where('id', $request->id)->first();
        if ($formFile->file_path && file_exists(public_path($formFile->file_path))) {
            unlink(public_path($formFile->file_path));
        }
        $formFile->delete();
        $files = FormFile::where('temp_serial', Session::get('temp_serial'))->get();
        return view('admin.formFile.index', compact('files'));
    }
}
