<?php

namespace App\Console\Commands;

use App\Mail\ProjectFormEmail;
use App\Models\Form;
use App\Models\ProjectForm;
use App\Models\ProjectFormInput;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use App\Traits\FirebaseNotification;


class PublishFormCron extends Command
{
    use FirebaseNotification;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'publishForm:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $publishForms = Form::where('periodic_onetime', 'periodic')->where('nex_send_date', date('Y-m-d'))->get();
        foreach ($publishForms as $key => $form) {
            foreach ($form->projects as $project) {
                switch ($form->periodic_type) {
                    case 'week':
                        $form->nex_send_date = date('Y-m-d', strtotime('+7 day'));
                        break;
                    case 'month':
                        $form->nex_send_date = date('Y-m-d', strtotime('+31 day'));
                        break;
                    case 'quarter':
                        $form->nex_send_date = date('Y-m-d', strtotime('+91 day'));
                        break;
                    default:
                        # code...
                        break;
                }
                $form->save();
                $now = Carbon::now();
                $date = $now->addDays($form->dead_line_by_num_of_dayes);
                $projectForm = new ProjectForm;
                $projectForm->serial_number = Str::random(10);
                $projectForm->project_id = $project->id;
                $projectForm->form_id = $form->id;
                $projectForm->expiration_date = $date;
                // return $projectForm;
                $projectForm->save();
                foreach ($form->formInputs as $key => $value) {
                    $projectFormInput = new ProjectFormInput;
                    $projectFormInput->project_form_id = $projectForm->id;
                    $projectFormInput->form_input_id = $value->id;
                    $projectFormInput->input_type = $value->input_type;
                    $projectFormInput->calculated = $value->calculated;
                    $projectFormInput->answer = ($value->calculated == 1) ? 0 : null;
                    $projectFormInput->save();
                }
                //send notifications and mail
                $title = "Hello, " . $project->name;
                $type = "fill_form";
                $form_id = $projectForm->id;
                $message = "Hello, " . $project->name . "New Publishable Form " . $form->name . "Petrojet HSE form builder should be filled";
                if ($project->fcm_token) {
                    $this->sendNotification($project->id, $title, $message, $type, $form_id);
                }
                if ($project->email) {
                    try {
                        Mail::to($project->email)->send(new ProjectFormEmail($project->name, $form->name, $form_id, $type));
                    } catch (\Swift_TransportException $e) {
                        //throw $th;
                    }
                }
            }
        }
        $oneTimeForms = Form::where(['periodic_onetime' => 'onetime', 'one_time_type' => 'spacific'])->where('one_type_send_time', date('Y-m-d'))->get();
        foreach ($oneTimeForms as $key => $value) {
            foreach ($value->projects as $project) {
                $now = Carbon::now();
                $date = $now->addDays($value->dead_line_by_num_of_dayes);
                $projectForm = new ProjectForm;
                $projectForm->serial_number = Str::random(10);
                $projectForm->project_id = $project->id;
                $projectForm->form_id = $value->id;
                $projectForm->expiration_date = $date;
                $projectForm->save();
                foreach ($value->formInputs as $key => $value2) {
                    $projectFormInput = new ProjectFormInput;
                    $projectFormInput->project_form_id = $projectForm->id;
                    $projectFormInput->form_input_id = $value2->id;
                    $projectFormInput->input_type = $value2->input_type;
                    $projectFormInput->calculated = $value2->calculated;
                    $projectFormInput->answer = ($value2->calculated == 1) ? 0 : null;
                    $projectFormInput->save();
                }
                $value->one_type_send_time = null;
                $value->save();
                //send notifications and mail
                $title = "Hello, " . $project->name;
                $type = "fill_form";
                $form_id = $projectForm->id;
                $message = "Hello, " . $project->name . "New Publishable Form " . $value->name . "Petrojet HSE form builder should be filled";
                if ($project->fcm_token) {
                    $this->sendNotification($project->id, $title, $message, $type, $form_id);
                }
                if ($project->email) {
                    try {
                        Mail::to($project->email)->send(new ProjectFormEmail($project->name, $value->name, $form_id, $type));
                    } catch (\Swift_TransportException $e) {
                        //throw $th;
                    }
                }
            }
        }
        Log::info("publish Form Cron is working fine!");
        return Command::SUCCESS;
    }
}
