<?php

namespace App\Console\Commands;

use App\Mail\ProjectFormEmail;
use App\Models\Form;
use App\Models\ProjectForm;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use App\Traits\FirebaseNotification;

class ExpireFormsCron extends Command
{
    use FirebaseNotification;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ExpireForms:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $forms = ProjectForm::where('expiration_date', '<', Carbon::now())->whereIn('status', ['waiting', 'incomplete'])->get();
        foreach ($forms as $key => $form) {
            $form->status = 'expired';
            $form->save();
            $title = "Hello, " . $form->project->name;
            $type = "form_expired";
            $form_id = $form->id;
            $message = "Hello, " . $form->project->name . "Form " . $form->name . "Petrojet HSE form builder Expired soon Hury to fill it now.";
            if ($form->project->fcm_token) {
                $this->sendNotification($form->project->id, $title, $message, $type, $form_id);
            }
            if ($form->project->email) {
                try {
                    Mail::to($form->project->email)->send(new ProjectFormEmail($form->project->name, $form->form->name, $form_id, $type));
                } catch (\Swift_TransportException $e) {
                    //throw $th;
                }
            }
        }
        Log::info("Expire Forms Cron is working fine!");
        return Command::SUCCESS;
    }
}
