<?php

use App\Http\Controllers\Api\FormController;
use App\Http\Controllers\Api\PageController;
use App\Http\Controllers\Api\ProjectController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::post('login', [ProjectController::class, 'login']);
Route::get('branches', [ProjectController::class, 'getBranches']);
Route::get('projects/{branch_id}', [ProjectController::class, 'getProjects']);
Route::get('pages', [PageController::class, 'pages']);
Route::get('page/{page_id}', [PageController::class, 'getPageById']);
Route::middleware('auth:api')->group(function () {
    Route::get('projectForms', [FormController::class, 'projectForms']);
    Route::get('getFormFields', [FormController::class, 'getFormFields']);
    Route::post('submitFormInputs', [FormController::class, 'submitFormInputs']);
});
