@forelse ($forms as $key => $form)
    @switch($form->status)
        @case('waiting')
            <tr>
                <td>{{ $form->serial_number }}</td>
                <td>{{ $form->form->name }}</td>
                <td>
                    {{ date('M j, Y', strtotime($form->created_at)) }}</td>
                <td>{{ date('M j, Y', strtotime($form->expiration_date)) }}</td>
                <td class="text-end">
                    <a style="text-decoration: none" href="{{ route('fillForm', $form->id) }}" class="view-button bg-blue">
                        View
                    </a>

                </td>
            </tr>
        @break

        @case('incomplete')
            <tr>
                <td>{{ $form->serial_number }}</td>
                <td>{{ $form->form->name }}</td>
                <td>
                    {{ date('M j, Y', strtotime($form->created_at)) }}</td>
                <td>{{ date('M j, Y', strtotime($form->expiration_date)) }}</td>
                <td class="text-end">
                    <a style="text-decoration: none" href="{{ route('fillForm', $form->id) }}" class="view-button bg-purple">
                        View
                    </a>
                </td>
            </tr>
        @break

        @case('expired')
            <tr>
                <td>{{ $form->serial_number }}</td>
                <td>{{ $form->form->name }}</td>
                <td>
                    {{ date('M j, Y', strtotime($form->created_at)) }}</td>
                <td>{{ date('M j, Y', strtotime($form->expiration_date)) }}</td>
                <td class="text-end">
                    <a style="text-decoration: none" href="{{ route('fillForm', $form->id) }}" class="view-button bg-red">
                        View
                    </a>
                </td>
            </tr>
        @break

        @case('done')
            <tr>
                <td>{{ $form->serial_number }}</td>
                <td>{{ $form->form->name }}</td>
                <td>
                    {{ date('M j, Y', strtotime($form->created_at)) }}</td>
                <td>{{ date('M j, Y', strtotime($form->expiration_date)) }}</td>
                <td class="text-end">
                    <a style="text-decoration: none" href="{{ route('viewForm', $form->id) }}" class="view-button bg-green">
                        View
                    </a>
                </td>
            </tr>
        @break

        @default
    @endswitch

    @empty
    @endforelse
