@extends('layouts.front')
@section('content')
    <main class="container-fluid view-container">
        <div class="container">
            <div class="row pt-5 pt-5">
                <div class="col-lg-10 col-md-10 col-sm-12 view-card m-auto">
                    <div class="row w-50 ms-auto align-items-center">
                        <div class="col-md-10 mb-5 text-end">
                            @php
                                $percentage = ($currentInputsNum / $totalInputs) * 100;
                            @endphp
                            <div class="progress" style="height:5px">
                                <div class="progress-bar bg-danger" role="progressbar" style="width: {{ $percentage }}%" aria-valuenow="{{ $totalInputs }}"
                                    aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
                        <div class="col-md-2 mb-5 text-end">
                            <span>{{ $currentInputsNum }}/{{ $totalInputs }}</span>
                        </div>
                    </div>
                    <h3>{{ $projectForm->form->name }}</h3>
                    <div class="content">
                        <div class="row">
                            <h5 class="text-end">{{ $projectForm->expiration_date }}</h5>
                        </div>
                        <div class="form-content">
                            <div class="d-flex justify-content-between">
                                <div class="attached-title d-flex justify-content-center">
                                    <h5>
                                        Attached Files
                                    </h5>
                                </div>
                            </div>
                            <div class="attached-data">
                                <div class="row align-items-center">
                                    @foreach ($projectForm->form->formFiles as $file)
                                        @switch($file->type)
                                            @case('image/png')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox="gallery">
                                                        <img width="50px" height="50px" src="{{ url($file->file_path) }}"
                                                            alt="">
                                                    </a>
                                                </div>
                                            @break

                                            @case('application/pdf')
                                                <div class="col-xl-3 col-md-12">
                                                    <a href="{{ url($file->file_path) }}" data-fancybox data-type="iframe">
                                                        <img src="{{ url('front_end/assets/imgs/file-icon.png') }}" alt="">
                                                    </a>
                                                </div>
                                            @break

                                            @default
                                        @endswitch
                                    @endforeach


                                </div>
                            </div>
                        </div>
                        <form action="{{ route('submitFillForm') }}" method="POST" enctype='multipart/form-data'>
                            @csrf
                            <input type="hidden" name="project_form_id" value="{{ $project_form_id }}">
                            <input type="hidden" name="nextPage" value="{{ $nextPage }}">
                            <input type="hidden" name="prevPage" value="{{ $prevPage }}">
                            <input type="hidden" name="show_submit" value="{{ $show_submit }}">
                            <input type="hidden" name="totalPages" value="{{ $totalPages }}">
                            <div class="form-content">
                                <div class="form-data">
                                    <div class="row">
                                        @foreach ($formInputs as $key => $input)
                                            @switch($input->input_type)
                                                @case('text')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="text-input"
                                                            class="form-label">{{ $input->formInput->label }}</label>
                                                        <input name="inputs[{{ $input->id }}][answer]" type="text"
                                                            id="text-input{{ $key }}" value="{{ $input->answer }}"
                                                            class="form-control">
                                                        <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                            value="{{ $input->input_type }}">
                                                    </div>
                                                @break

                                                @case('number')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="number-input"
                                                            class="form-label">{{ $input->formInput->label }}</label>
                                                        <input type="number" value="{{ $input->answer }}"
                                                            id="number-input{{ $key }}" class="form-control"
                                                            name="inputs[{{ $input->id }}][answer]">
                                                        <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                            value="{{ $input->input_type }}">
                                                    </div>
                                                @break

                                                @case('textarea')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3">
                                                        <label for="textarea-input"
                                                            class="form-label">{{ $input->formInput->label }}</label>
                                                        <textarea class="form-control resize-none" name="inputs[{{ $input->id }}][answer]"
                                                            id="textarea-input{{ $key }}" rows="3">{{ $input->answer }}</textarea>
                                                        <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                            value="{{ $input->input_type }}">
                                                    </div>
                                                @break

                                                @case('file')
                                                    <div class="form-group col-xl-12 col-sm-12 mb-3 custom-file">
                                                        <label for="number-input"
                                                            class="form-label">{{ $input->formInput->label }}</label>
                                                        <input type="file" id="file-input{{ $key }}"
                                                            name="inputs[{{ $input->id }}][answer]"
                                                            class="form-control custom-file-input">
                                                        <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                            value="{{ $input->input_type }}">
                                                        <img width="60px" class="img" src="" alt="">
                                                        @if ($input->answer)
                                                            <a href="{{ url($input->answer) }}" data-fancybox="gallery">
                                                                <img class="old-img" width="60px"
                                                                    src="{{ url($input->answer) }}" alt="">
                                                            </a>
                                                        @endif
                                                    </div>
                                                @break

                                                @default
                                            @endswitch
                                        @endforeach

                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                @if ($prevPage != 0)
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper">
                                        <button type="submit" name="submit_type" value="prev"
                                            class="btn save-btn d-block py-2 fs-5">Prev</button>
                                    </div>
                                @endif
                                @if ($show_submit == true)
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper ms-auto">
                                        <button type="submit" name="submit_type" value="submit"
                                            class="btn save-btn d-block py-2 fs-5">Save</button>
                                    </div>
                                @else
                                    <div class="col-lg-2 col-md-6 col-sm-12 save-btn-wrapper ms-auto">
                                        <button type="submit" name="submit_type" value="next"
                                            class="btn save-btn d-block py-2 fs-5">Next</button>
                                    </div>
                                @endif

                            </div>
                        </form>
                    </div>

                </div>


            </div>
        </div>
    </main>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-fancybox="gallery"]').fancybox({
                loop: true,
                keyboard: true,
                arrows: true,
                infobar: true,
                buttons: [
                    "thumbs",
                    "close"
                ]
            });

            $(".custom-file-input").change(function() {
                var img_src = jQuery(this).parents('.custom-file').find(
                    ".img");
                jQuery(this).parents('.custom-file').find(
                    ".old-img").css('display', 'none');
                if (typeof(FileReader) != "undefined") {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        img_src.attr("src", e.target.result);
                    }
                    reader.readAsDataURL($(this)[0].files[0]);
                } else {
                    alert("This browser does not support FileReader.");
                }

            });
        })
    </script>
@endsection
