@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> {{ trans('messages.Show Form') }}</h3>
            </div>

        </div>
    </div>
    <style>
        #gallery-content-center img {
            width: 70px;
        }
    </style>
    <section class="content">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="box">
                    <div class="box-body">
                        <div class="row pt-5 pt-5">
                            <div class="col-lg-10 col-md-10 col-sm-12 view-card m-auto">
                                <h3>{{ $projectForm->form->name }}</h3>
                                @php
                                    $bills = [
                                        'waiting' => 'badge-info-light',
                                        'incomplete' => 'badge-primary-light',
                                        'expired' => 'badge-danger-light',
                                        'done' => 'badge-warning-light',
                                    ];
                                @endphp
                                <div class="content">
                                    <div>
                                        <h5 class="">{{ $projectForm->expiration_date }}</h5>
                                        <div class="badge badge-pill {{ $bills[$projectForm->status] }}">
                                            {{ $projectForm->status }}</div>
                                    </div>
                                    <br>
                                    <div class="form-content">
                                        <div class="d-flex justify-content-between">
                                            <div class="attached-title d-flex justify-content-center">
                                                <h5>
                                                    Attached Files
                                                </h5>
                                            </div>
                                        </div>
                                        <div class="attached-data">
                                            <div id="gallery-content">
                                                <div id="gallery-content-center">
                                                    @foreach ($projectForm->form->formFiles as $file)
                                                        @switch($file->type)
                                                            @case('image/png')
                                                                <a href="{{ url($file->file_path) }}" data-toggle="lightbox"
                                                                    data-gallery="multiimages"
                                                                    data-title="Show Form Files"><img
                                                                        src="{{ url($file->file_path) }}" alt="gallery"
                                                                        class="all studio" /> </a>
                                                            @break

                                                            @case('application/pdf')
                                                                <a href="{{ url($file->file_path) }}" data-toggle="lightbox"
                                                                    data-gallery="multiimages"
                                                                    data-title="Show Form Files"><img
                                                                        src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                                        alt="gallery" class="all studio" /> </a>
                                                                {{-- <div class="col-xl-3 col-md-12">
                                                                    <a href="{{ url($file->file_path) }}" data-fancybox
                                                                        data-type="iframe">
                                                                        <img src="{{ url('front_end/assets/imgs/file-icon.png') }}"
                                                                            alt="">
                                                                    </a>
                                                                </div> --}}
                                                            @break

                                                            @default
                                                        @endswitch
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @foreach ($formInputs as $key => $input)
                                        @switch($input->input_type)
                                            @case('text')
                                                <div class="form-group mb-3">
                                                    <label for="text-input"
                                                        class="form-label">{{ $input->formInput->label }}</label>
                                                    <input name="inputs[{{ $input->id }}][answer]" type="text"
                                                        id="text-input{{ $key }}" value="{{ $input->answer }}"
                                                        class="form-control" disabled>
                                                </div>
                                            @break
                                            @case('number')
                                                <div class="form-group mb-3">
                                                    <label for="number-input"
                                                        class="form-label">{{ $input->formInput->label }}</label>
                                                    <input type="number" value="{{ $input->answer }}" disabled
                                                        id="number-input{{ $key }}" class="form-control"
                                                        name="inputs[{{ $input->id }}][answer]">
                                                </div>
                                            @break
                                            @case('textarea')
                                                <div class="form-group mb-3">
                                                    <label for="textarea-input"
                                                        class="form-label">{{ $input->formInput->label }}</label>
                                                    <textarea disabled class="form-control resize-none" name="inputs[{{ $input->id }}][answer]"
                                                        id="textarea-input{{ $key }}" rows="3">{{ $input->answer }}</textarea>
                                                    <input type="hidden" name="inputs[{{ $input->id }}][type]"
                                                        value="{{ $input->input_type }}">
                                                </div>
                                            @break
                                            @case('file')
                                                <div class="form-group mb-3 custom-file">
                                                    <label for="number-input"
                                                        class="form-label">{{ $input->formInput->label }}</label>
                                                    <br>
                                                    @if ($input->answer)
                                                        <div style="margin-bottom: 2em;height: 5em">
                                                            <a href="{{ url($input->answer) }}" data-fancybox="gallery">
                                                                <img class="old-img" style="height:100%;width: auto"
                                                                    src="{{ url($input->answer) }}" alt="">
                                                            </a>
                                                        </div>
                                                    @endif
                                                </div>
                                                <br>
                                                <br>
                                            @break
                                            @default
                                        @endswitch
                                    @endforeach

                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('modal')
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        // delegate calls to data-toggle="lightbox"
        $(document).delegate('*[data-toggle="lightbox"]:not([data-gallery="navigateTo"])', 'click', function(event) {
            event.preventDefault();
            return $(this).ekkoLightbox({
                onShown: function() {
                    if (window.console) {
                        return console.log('Checking our the events huh?');
                    }
                },
                onNavigate: function(direction, itemIndex) {
                    if (window.console) {
                        return console.log('Navigating ' + direction + '. Current item: ' + itemIndex);
                    }
                }
            });
        });
        //Programatically call
        $('#open-image').click(function(e) {
            e.preventDefault();
            $(this).ekkoLightbox();
        });
        $('#open-youtube').click(function(e) {
            e.preventDefault();
            $(this).ekkoLightbox();
        });
        // navigateTo
        $(document).delegate('*[data-gallery="navigateTo"]', 'click', function(event) {
            event.preventDefault();
            var lb;
            return $(this).ekkoLightbox({
                onShown: function() {
                    lb = this;
                    $(lb.modal_content).on('click', '.modal-footer a', function(e) {
                        e.preventDefault();
                        lb.navigateTo(2);
                    });
                }
            });
        });
    </script>
@endsection
