@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> {{ trans('messages.Show Project') }}</h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <h3>{{ $project->name }}({{ $project->branch->name }})</h3>
                <h3>{{ $project->email }}</h3>
            </div>
            <div class="box-body no-padding">
                <h3 class="text-center">{{ trans('messages.Project Forms') }}</h3>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center">{{ trans('messages.Serial') }}</th>
                                <th class="text-center">{{ trans('messages.Branch') }}</th>
                                <th class="text-center">{{ trans('messages.Project') }}</th>
                                <th class="text-center">{{ trans('messages.Form Name') }}</th>
                                <th class="text-center">{{ trans('messages.Status') }}</th>
                                <th class="text-center">{{ trans('messages.Expiration') }}</th>
                                <th class="text-center">{{ trans('messages.Created') }}</th>
                                <th class="text-center">{{ trans('messages.Options') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $bills = [
                                    'waiting' => 'badge-info-light',
                                    'incomplete' => 'badge-primary-light',
                                    'expired' => 'badge-danger-light',
                                    'done' => 'badge-warning-light',
                                ];
                            @endphp
                            @foreach ($forms as $key => $form)
                                <tr>
                                    <td class="text-center">
                                        {{ $key + 1 }}
                                    </td>
                                    <td class="text-center">{{ $form->serial_number }}</td>
                                    <td class="text-center">{{ $form->project->branch->name }}</td>
                                    <td class="text-center">{{ $form->project->name }}</td>
                                    <td class="text-center">{{ $form->form->name }}</td>
                                    <td class="text-center">
                                        <div class="badge badge-pill {{ $bills[$form->status] }}">{{ $form->status }}
                                        </div>
                                    </td>
                                    <td class="text-center">{{ $form->expiration_date }}</td>
                                    <td class="text-center">{{ $form->created_at }}</td>
                                    <td class="text-center">
                                        <a href="{{ route('projectForm.show', $form->id) }}"
                                            class="waves-effect waves-light btn btn-primary-light btn-circle mx-5"><span
                                                class="mdi mdi-magnify"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('modal')
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript"></script>
@endsection
