@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> {{ trans('messages.Projects') }}</h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-4">
                        <div class="app-menu">
                            <div class="search-bx mx-5">
                                <form action="{{ route('project.index') }}" method="GET">
                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                            @isset($sort_search) value="{{ $sort_search }}" @endisset
                                            placeholder="{{ trans('messages.Name') }}" aria-label="Search"
                                            aria-describedby="button-addon2">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col" style="text-align: end">
                        <div class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                class="fa fa-fw fa-file-excel-o" id="show-input"><span class="path1"></span><span
                                    class="path2"></span></span></div>
                        <input type="file" id="importFieldsFile" style="display:none">

                        <a href="{{ url('importProjectExample.xlsx') }}" target="blank"
                            class="waves-effect waves-light btn btn-primary-light btn-circle"><span>
                                <img src="{{ url('excelImage.png') }}" style="width: 30px;" alt="">
                                <span class="path1"></span><span class="path2"></span></span></a>

                        <a href="{{ route('project.create') }}"
                            class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                class="mdi mdi-plus"><span class="path1"></span><span class="path2"></span></span></a>

                    </div>
                </div>

            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center">{{ trans('messages.Name') }}</th>
                                <th class="text-center">{{ trans('messages.Hse Manager Name') }}</th>
                                <th class="text-center">{{ trans('messages.Branch') }}</th>
                                <th class="text-center">{{ trans('messages.Email') }}</th>
                                <th class="text-center">{{ trans('messages.Created') }}</th>
                                <th class="text-center">{{ trans('messages.Options') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($projects as $key => $project)
                                <tr>
                                    <td class="text-center">
                                        {{ $key + 1 + ($projects->currentPage() - 1) * $projects->perPage() }}
                                    </td>
                                    <td class="text-center">{{ $project->name }}</td>
                                    <td class="text-center">{{ $project->hse_manager_name }}</td>
                                    <td class="text-center">{{ $project->branch->name }}</td>
                                    <td class="text-center">{{ $project->email }}</td>
                                    <td class="text-center">{{ $project->created_at }}</td>
                                    <td class="text-center">
                                        <form action="{{ route('project.destroy', $project->id) }}" method="Post"
                                            id="destroy-form-{{ $project->id }}">
                                            @csrf
                                            @method('DELETE')
                                        </form>
                                        <a href="{{ route('project.show', $project->id) }}"
                                            class="waves-effect waves-light btn btn-primary-light btn-circle mx-5"><span
                                                class="mdi mdi-magnify"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                        <a href="{{ route('project.edit', $project->id) }}"
                                            class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                class="icon-Write"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                        <a data-title="{{ trans('messages.Are you sure?') }}"
                                            data-no="{{ trans('messages.Cancel') }}"
                                            data-yes="{{ trans('messages.Yes, delete it!') }}"
                                            data-desc="{{ trans('messages.You will not be able to recover this!') }}"
                                            href="#" data-href="{{ $project->id }}"
                                            class="sa-warning waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                class="icon-Trash1"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                    {!! $projects->withQueryString()->links('pagination::bootstrap-4') !!}

                </div>
            </div>
        </div>
    </section>
@endsection
@section('modal')
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $('#show-input').click(function() {
            $('#importFieldsFile').click()
        })
        $('#importFieldsFile').change(function() {
            var file_data = $('#importFieldsFile').prop('files')[0];
            var form_data = new FormData();
            form_data.append('file', file_data);
            form_data.append('_token', '{{ csrf_token() }}');
            $.ajax({
                url: '{{ route('project.uploadProjectExcelFile') }}',
                dataType: 'text',
                cache: false,
                contentType: false,
                processData: false,
                data: form_data,
                type: 'post',
                success: function(response) {
                    window.location.reload();
                },
                error: function(xhr, status, error) {
                    console.log(error);
                }
            });
        });
    </script>
@endsection
