<div class="container">
    <div class="row">
        @foreach ($files as $file)
            <div class="col-md-3">
                <div class="thumbnail">
                    @if (in_array(strtolower(pathinfo($file->file_path, PATHINFO_EXTENSION)), ['jpg', 'jpeg', 'png', 'gif']))
                        <img src="{{ url($file->file_path) }}" class="img-responsive">
                    @else
                        <i class="fa fa-file-pdf-o fa-5x"></i>
                    @endif
                    <div class="caption">
                        <i style="cursor: pointer" class="btn btn-danger btn-xs pull-right fa fa-trash delete-form-file"
                            mid="{{ $file->id }}"></i>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>

<style>
    .thumbnail {
        padding: 1em;
        border: 2px solid;
        border-radius: 1em;
    }
</style>

<script type="text/javascript">
    console.log(document.getElementById('delete-form-file'));
    $('.delete-form-file').click(function() {
        var id = $(this).attr('mid');
        $.post(`{{ route('formFile.delete') }}`, {
                _token: '{{ csrf_token() }}',
                id: id
            },
            function(data) {
                $('#delete-modal-' + id).hide();
                $('.uploaded-files-container').html(data);

            });
    });
</script>
