@foreach ($data as $key => $item)
    @if ($key != 0)
        <div class="row" id="oneFieldContainer_{{ $inputCounter + $key }}">
            <div class="col-6">
                <div class="form-group">
                    <input type="text" class="form-control text-center"
                        placeholder="{{ trans('messages.Form Field Text') }}"
                        name="inputs[{{ $inputCounter + $key }}][label]" value="{{ $item[0] }}">
                </div>
            </div>
            <div class="col">
                <div class="form-group form-group-float">
                    <select class="form-control select-field-type" name="inputs[{{ $inputCounter + $key }}][input_type]"
                        id="select-field-type-{{ $inputCounter + $key }}">
                        <option value="text" {{ $item[1] == 'text' ? 'selected' : '' }}>{{ trans('messages.Text') }}
                        </option>
                        <option value="number" {{ $item[1] == 'number' ? 'selected' : '' }}>
                            {{ trans('messages.Number') }}</option>
                        <option value="textarea" {{ $item[1] == 'textarea' ? 'selected' : '' }}>
                            {{ trans('messages.Long text') }}</option>
                        <option value="file" {{ $item[1] == 'file' ? 'selected' : '' }}>{{ trans('messages.File') }}
                        </option>
                    </select>
                </div>
            </div>
            <div class="col-2 demo-checkbox" id="demo-checkbox-{{ $inputCounter + $key }}"
                style="{{ $item[1] != 'number' ? 'display: none;' : '' }}">
                <div class="demo-checkbox">
                    <input type="checkbox" id="md_checkbox_{{ $inputCounter + $key }}"
                        name="inputs[{{ $inputCounter + $key }}][calculated]" class="filled-in chk-col-danger"
                        {{ $item[2] == 1 ? 'checked' : '' }} />
                    <label for="md_checkbox_{{ $inputCounter + $key }}">Auto Calculated</label>
                </div>
            </div>
            <div class="col-1">
                <i class="fa fa-trash" style="cursor: pointer;font-size: 1.5em"
                    onclick="deleteoneFieldContainer({{ $inputCounter + $key }})"></i>
            </div>
        </div>

        <script type="text/javascript">
            $('#select-field-type-{{ $inputCounter + $key }}').change(function() {
                if ($(this).val() == 'number') {
                    $("#demo-checkbox-{{ $inputCounter + $key }}").show();
                } else {
                    $("#demo-checkbox-{{ $inputCounter + $key }}").hide();
                }
            })
        </script>
    @endif
@endforeach
