@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title">{{ trans('messages.Add New Form') }}</h3>
            </div>

        </div>
    </div>

    <style>
        .bootstrap-tagsinput {
            width: 100%;
            padding: 0.6em;
        }

        .box {
            border-top: 20px solid #C4161C;
            border-radius: 20px;
            border-bottom: 20px solid #C4161C !important;
            box-shadow: none !important;
        }

        .box-header {
            border-bottom: 13px solid #f8f8fb;
        }

        .input-group .input-group-text {

            border-color: #C4161C
        }

        .form-name input {
            border-left: none;
        }

        .btn-filled {
            background-color: #000000 !important;
            border: none
        }

        .add-new-field {
            border-right: 2px solid #000000;
        }

        .add-new-field i {
            cursor: pointer;
            font-size: 1.5em;
            position: absolute;
            bottom: 15px;
            right: 5px;
        }

        .theme-primary [type=radio]:checked+label:after {
            border: 2px solid #C4161C;
            background-color: #C4161C;
        }

        .progress {
            position: relative;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: white;
            overflow: hidden;
            background-image: conic-gradient(red 0%, rgba(255, 136, 136, 0.644) 0);
        }

        .progress .inner {
            display: flex;
            justify-content: center;
            align-items: center;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 34px;
            height: 34px;
            background: white;
            border-radius: 50%;
            font-size: 1em;
            font-weight: 400;
        }
    </style>
    <!-- Main content -->

    <section class="content">
        <div class="row">
            <div class="col-lg-8">

                <div class="box">
                    {!! Form::open(['route' => 'form.store', 'files' => true, 'id' => 'add-form-form']) !!}
                    <div class="box-header">
                        <div class="row">
                            <div class="col-6 mx-auto">
                                <div class="form-group">
                                    <div class="input-group mb-3 form-name">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i style="font-size: 1.5em;"
                                                    class="fa fa-fw fa-file"></i></span>
                                        </div>
                                        {!! Form::text('name', null, [
                                            'class' => 'form-control text-center',
                                            'placeholder' => trans('messages.Form Name'),
                                        ]) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="box-body">
                        <h3 class="text-center">{{ trans('messages.Import Exel file') }}
                            {{-- <input type="file" id="importFieldsFile" class="fa fa-fw fa-file-excel-o" style="width: 0.85614em;cursor: pointer;"> --}}
                            <i class="fa fa-fw fa-file-excel-o" style="cursor: pointer" id="show-input"></i>
                            <input type="file" id="importFieldsFile" style="display:none">
                        </h3>
                        <h5 class="text-center">
                            Example
                            <i class="fa fa-arrow fa-arrow-right"></i>
                            <a href="{{ url('importFormExample.xlsx') }}" target="blank">
                                <img src="{{ url('excelImage.png') }}" width="25px" alt="">
                            </a>
                        </h5>
                        <br>
                        <div class="row">
                            <div class="col-1 add-new-field" style="position: relative;">
                                <i id="add-new-field-i" title="{{ trans('messages.Add new field') }}"
                                    class="fa fa-plus"></i>
                            </div>
                            <div class="col" id="form-fields-container">

                            </div>
                        </div>
                        <hr>
                        <h5 class="text-center">{{ trans('messages.Form Delevery Type') }}</h5>
                        <div class="row text-center">
                            <div class="col">
                                <input name="periodic_onetime" type="radio" id="radio_2" value="onetime" checked />
                                <label for="radio_2">{{ trans('messages.One Time') }}</label>
                            </div>
                            <div class="col">
                                <input name="periodic_onetime" type="radio" id="radio_1" value="periodic" />
                                <label for="radio_1">{{ trans('messages.Periodic') }}</label>
                            </div>

                        </div>
                        <hr>
                        <div class="periodic-opthions" style="display: none">
                            <h5 class="text-center">{{ trans('messages.Periodic Type') }}</h5>
                            <div class="row text-center">
                                <div class="col">
                                    <input name="periodic_type" type="radio" id="radio_3" value="week" checked />
                                    <label for="radio_3">{{ trans('messages.Every Week') }}</label>
                                </div>
                                <div class="col">
                                    <input name="periodic_type" type="radio" id="radio_4" value="month" />
                                    <label for="radio_4">{{ trans('messages.Every Month') }}</label>
                                </div>
                                <div class="col">
                                    <input name="periodic_type" type="radio" id="radio_5" value="quarter" />
                                    <label for="radio_5">{{ trans('messages.Every Quarter') }}</label>
                                </div>
                            </div>
                            <hr>
                            <div class="row text-center">
                                <div class="col-4 mx-auto select-periodic-type-container">
                                    <div class="form-group">
                                        <label for="week_day">{{ trans('messages.Choose Week Day') }}</label>
                                        <select name="week_day" id="week_day" class="form-control">
                                            <option value="1">{{ trans('messages.Monday') }}</option>
                                            <option value="2">{{ trans('messages.Tuesday') }}</option>
                                            <option value="3">{{ trans('messages.Wednesday') }}</option>
                                            <option value="4">{{ trans('messages.Thursday') }}</option>
                                            <option value="5">{{ trans('messages.Friday') }}</option>
                                            <option value="6">{{ trans('messages.Saturday') }}</option>
                                            <option value="7">{{ trans('messages.Sunday') }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md">
                                <div class="form-group">
                                    <label for="dead_line_by_num_of_dayes">{{ trans('messages.Form Files') }}</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="customFile">
                                        <label class="custom-file-label" for="customFile">Choose file</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-1" style="display: none" id="file-upload-progress-container">
                                <label></label>
                                <div class="wrap-progress">
                                    <div class="progress" id="file-upload-progress">
                                        <div class="inner">0%</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="dead_line_by_num_of_dayes">{{ trans('messages.Deadline') }}</label>
                                    <select name="dead_line_by_num_of_dayes" id="dead_line_by_num_of_dayes"
                                        class="form-control">
                                        <option value="1">1 Day</option>
                                        <option value="2">2 Day</option>
                                        <option value="3">3 Day</option>
                                        <option value="4">4 Day</option>
                                        <option value="5">5 Day</option>
                                        <option value="6">6 Day</option>
                                        <option value="7">7 Day</option>
                                        <option value="8">8 Day</option>
                                        <option value="9">9 Day</option>
                                        <option value="10">10 Day</option>
                                    </select>
                                </div>
                            </div>
                        </div>


                        <br>
                        <br>
                        <div class="form-group">
                            <button type="submit"
                                class="btn btn-rounded btn-primary btn-filled form-control">{{ trans('messages.Next') }}
                            </button>
                        </div>


                    </div>
                    {!! Form::Close() !!}
                </div>

                <!-- /.box-body -->

            </div>
            <div class="col-md">
                <div class="box">
                    <div class="box-header">
                        <h4 class="text-center" style="padding-bottom: 1em">{{ trans('messages.Form Files') }}</h4>
                    </div>
                    <div class="box-body">
                        <div class="uploaded-files-container">

                        </div>
                        <table>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
    </section>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            $.get(`{{ route('formFile.index') }}`, {
                    temp_serial: `{{ session('temp_serial') }}`
                },
                function(data2) {
                    $('.uploaded-files-container').html(data2);

                });

            var inputCounter = 0;
            $('.select2').select2();
            $.get(`{{ route('form.addField') }}`, {
                    inputCounter: inputCounter
                },
                function(data) {
                    $('#form-fields-container').append(data);
                });
            $('#add-new-field-i').click(function() {
                inputCounter++;
                $.get(`{{ route('form.addField') }}`, {
                        inputCounter: inputCounter
                    },
                    function(data) {
                        $('#form-fields-container').append(data);

                    });
            })

            $('input[name=periodic_onetime]').change(function() {
                var selectedValue = $('input[name=periodic_onetime]:checked').val();
                if (selectedValue == 'onetime') {
                    $('.periodic-opthions').hide();
                } else {
                    $('.periodic-opthions').show();
                }
            });
            $('input[name=periodic_type]').change(function() {
                var selectedValue = $('input[name=periodic_type]:checked').val();
                $.get(`{{ route('form.getPeriodicTypeSelect') }}`, {
                        selectedValue: selectedValue
                    },
                    function(data) {
                        $('.select-periodic-type-container').html(data);

                    });
            });

            $('#show-input').click(function() {
                $('#importFieldsFile').click()
            })
            // document.querySelector('input[type="file"]').addEventListener('change', function() {
            //     var formData = new FormData();
            //     formData.append('file', document.querySelector('input[type="file"]').files[0]);
            //     formData.append('temp_serial', `{{ session('temp_serial') }}`);
            //     formData.append('_token', '{{ csrf_token() }}');
            //     $.ajax({
            //         type: "POST",
            //         url: `{{ route('formFile.store') }}`,
            //         data: formData,
            //         processData: false,
            //         contentType: false,
            //         success: function(data) {
            //             if (data.success == true) {
            //                 $.get(`{{ route('formFile.index') }}`, {
            //                         temp_serial: `{{ session('temp_serial') }}`
            //                     },
            //                     function(data2) {
            //                         $('.uploaded-files-container').html(data2);

            //                     });
            //             } else {
            //                 console.log(data)
            //             }

            //         }
            //     });
            // });

            document.querySelector('input[id="customFile"]').addEventListener('change', function() {
                $('#file-upload-progress-container').slideToggle();
                var formData = new FormData();
                formData.append('file', document.querySelector('input[id="customFile"]').files[0]);
                formData.append('temp_serial', `{{ session('temp_serial') }}`);
                formData.append('_token', '{{ csrf_token() }}');
                var xhr = new XMLHttpRequest();
                xhr.open('POST', `{{ route('formFile.store') }}`);
                xhr.upload.addEventListener("progress", function(event) {

                    if (event.lengthComputable) {
                        var percentComplete = Math.round((event.loaded / event.total) * 100);
                        $('#file-upload-progress').css('background-image', 'conic-gradient(red ' +
                            percentComplete + '%, rgba(255, 136, 136, 0.644) 0)')
                        $('.progress .inner').text(percentComplete + '%');
                        if (percentComplete == 100) {
                            setTimeout(() => {
                                $('#file-upload-progress-container').hide();
                                $('#file-upload-progress').css('background-image',
                                    'conic-gradient(red ' +
                                    0 + '%, rgba(255, 136, 136, 0.644) 0)'
                                )
                                $('.progress .inner').text(0 + '%');
                            }, 500);
                        }
                    }
                }, false);

                xhr.onreadystatechange = function() {
                    console.log(xhr);
                    if (xhr.status == 200) {
                        var data = JSON.parse(xhr.responseText);
                        if (data.success == true) {
                            $.get(`{{ route('formFile.index') }}`, {
                                    temp_serial: `{{ session('temp_serial') }}`
                                },
                                function(data2) {
                                    $('.uploaded-files-container').html(data2);
                                });
                        } else {
                            console.log(data)
                        }
                    } else {
                        console.log('Error: ' + xhr.status);
                    }
                }

                xhr.send(formData);
            });
            $('#importFieldsFile').change(function() {
                var file_data = $('#importFieldsFile').prop('files')[0];
                var form_data = new FormData();
                form_data.append('inputCounter', inputCounter);
                form_data.append('file', file_data);
                form_data.append('_token', '{{ csrf_token() }}');

                $.ajax({
                    url: '{{ route('form.uploadFieldsFile') }}',
                    dataType: 'text',
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: form_data,
                    type: 'post',
                    success: function(response) {
                        $('#form-fields-container').append(response);
                    },
                    error: function(xhr, status, error) {
                        console.log(error);
                    }
                });
                form_data.append('getCounterUpdate', 1);
                $.ajax({
                    url: '{{ route('form.uploadFieldsFile') }}',
                    dataType: 'text',
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: form_data,
                    type: 'post',
                    success: function(response) {
                        inputCounter = response - 1;
                        // console.log(response);
                        // console.log(inputCounter);
                    },
                    error: function(xhr, status, error) {
                        console.log(error);
                    }
                });
            });

        })



        function deleteoneFieldContainer(counter) {
            $('#oneFieldContainer_' + counter).remove();
        }
    </script>
@endsection
