<?php

namespace App\Traits;

use App\Models\Project;
use App\Fcm;
use App\Traits\Fcm as TraitsFcm;
use Illuminate\Support\Facades\Log;

trait FirebaseNotification
{
    public static function sendMultiNotification($request, $projects)
    {
        $tokens = [];
        foreach ($projects as $project) {
            if (!empty($project->fcm_token) &&  $project->fcm_token != 1) {
                $tokens[] = $project->fcm_token;
            }
        }

        if ($tokens != null) {
            $data['type'] = $request->type;
            $data['value'] = $request->form_id;
            $fcm = new TraitsFcm;
            $fcm->setTitle($request->title);
            $fcm->setMessage($request->body);
            $fcm->setPayload($data);
            $json = $fcm->getPush();
            $fcm->sendMultiple($tokens, $json);
        }
    }

    public function sendNotification($project_id, $title, $message, $type, $form_id)
    {
        $project = Project::find($project_id);
        if ($project->fcm_token) {
            $token = $project->fcm_token;
            if ($token != null) {
                $data['type'] = $type;
                $data['value'] = $form_id;
                $fcm = new TraitsFcm;
                $fcm->setTitle($title);
                $fcm->setMessage($message);
                $fcm->setPayload($data);
                $json = $fcm->getPush();
                $fcm->send($token, $json);
            }
        }
    }
}
