<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;
    protected $fillable = [
        'facebook',
        'instegram',
        'tweetir',
        'linkedin',
        'youtube',
        'privacy_id',
        'terms_id',
    ];

    public function privacy()
    {
        return $this->belongsTo(Page::class, 'privacy_id');
    }

    public function terms()
    {
        return $this->belongsTo(Page::class, 'terms_id');
    }
}
